% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ArArRedux.R
\name{loadirradiations}
\alias{loadirradiations}
\title{Load the irradiation schedule}
\usage{
loadirradiations(fname)
}
\arguments{
\item{fname}{file name (in .csv format)}
}
\value{
a list of irradiations, where each irradiation is a named
list containing:

\code{tin}: vector with the start times of irradiations \cr
\code{tout}: vector with the end times of irradiations \cr
\code{P}: vector with the power of the irradiations
}
\description{
Loads a .csv file with the schedule of a multi-stage neutron
irradiation
}
\examples{
irrfile <- system.file("irradiations.csv",package="ArArRedux")
irr <- loadirradiations(irrfile)
str(irr)
}

