% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ArArRedux.R
\name{read}
\alias{read}
\title{Read mass spectrometer data}
\usage{
read(xfile, masses, blabel, Jpos, kfile = NULL, cafile = NULL,
  dfile = NULL, dlabels = NULL, MS = "ARGUS-VI")
}
\arguments{
\item{xfile}{a .csv file with samples and fluence monitor data}

\item{masses}{a list which specifies the order in which the isotopes
are recorded by the mass spectrometer}

\item{blabel}{a prefix string denoting the blanks}

\item{Jpos}{a vector of integers denoting the positions of the
fluence monitors in the irradiation stack}

\item{kfile}{a .csv file with the K-interference monitor data
(optional)}

\item{cafile}{a .csv file with the Ca-interference monitor data
(optional)}

\item{dfile}{a .csv file with the detector calibration data
(optional)}

\item{dlabels}{a list which specifies the names of the detectors
and the order in which they were recorded by the mass spectrometer}

\item{MS}{a string denoting the type of mass spectrometer. At the
moment only the ARGUS-IV is listed. Please contact the author to
add other file formats to Ar-Ar_Redux.}
}
\value{
an object of class \code{\link{redux}}.
}
\description{
Reads raw mass spectrometer data and parses it into a
\code{\link{redux}} format for further processing.
}
\examples{
samplefile <-  system.file("Samples.csv",package="ArArRedux")
kfile <- system.file("K-glass.csv",package="ArArRedux")
cafile <- system.file("Ca-salt.csv",package="ArArRedux")
dfile <- system.file("Calibration.csv",package="ArArRedux")
masses <- c("Ar37","Ar38","Ar39","Ar40","Ar36")
dlabels <- c("H1","AX","L1","L2")
X <- read(samplefile,masses,"EXB#",c(3,15),kfile,cafile,dfile,dlabels)
plotcorr(X)
}

