% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhasePlot.R
\name{PhasePlot}
\alias{PhasePlot}
\title{Plot the characteristics of a group of events}
\usage{
PhasePlot(
  PhaseMin_chain,
  PhaseMax_chain,
  level = 0.95,
  title = "Characterisation of a group of dates",
  colors = TRUE,
  exportFile = NULL,
  exportFormat = "PNG",
  GridLength = 1024
)
}
\arguments{
\item{PhaseMin_chain}{Numeric vector containing the output of the
MCMC algorithm for the minimum of the events included in the phase.}

\item{PhaseMax_chain}{Numeric vector containing the output of the
MCMC algorithm for the maximum of the events included in the phase.}

\item{level}{Probability corresponding to the level of confidence
used for the credible interval and the time range.}

\item{title}{The title of the plot}

\item{colors}{If \code{TRUE}, then use of colors in the plot,
otherwise draw the plot in black and white.}

\item{exportFile}{Name of the file to be saved. If \code{NULL}, then no plot is saved.}

\item{exportFormat}{Format of the export file, either "PNG" or "SVG".}

\item{GridLength}{Length of the grid used to estimate the density.}
}
\value{
\code{NULL}, called for its side effects
}
\description{
This function draws the marginal posterior densities of the minimum
and the maximum of the events included in the phase and
summary statistics including mean, credible interval, and time range.
The result is given in calendar years (BC/AD).
}
\examples{
  data(Phases); attach(Phases)
   PhasePlot(Phase.1.alpha, Phase.1.beta, level = 0.95, title = "Densities of Phase 1")


}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
