% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhaseTimeRange.R
\name{PhaseTimeRange}
\alias{PhaseTimeRange}
\title{Phase time range}
\usage{
PhaseTimeRange(PhaseMin_chain, PhaseMax_chain, level = 0.95)
}
\arguments{
\item{PhaseMin_chain}{: Numeric vector containing the output of the MCMC
algorithm for the minimum of the events included in the phase.}

\item{PhaseMax_chain}{: Numeric vector containing the output of the MCMC
algorithm for the maximum of the events included in the phase.}

\item{level}{Probability corresponding to the desired level of confidence.}
}
\value{
A vector of values containing the desired level of confidence
and the endpoints of the shortest time range associated with this desired level.
The result is given in calendar years (BC/AD).
}
\description{
Computes the shortest interval that satisfies
\eqn{P(PhaseMin_chain =< IntervalInf < IntervalSup =< PhaseMax_chain | M) = level}
}
\examples{
  data(Phases); attach(Phases)
  PhaseTimeRange(Phase.1.alpha, Phase.1.beta, 0.95)
  PhaseTimeRange(Phase.2.alpha, Phase.2.beta, 0.90)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
