% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtest_allocation.R
\name{backtest_allocation}
\alias{backtest_allocation}
\title{Backtesting of asset allocation strategies}
\usage{
backtest_allocation(strat, P, R, risk_free = 0, start_date = NULL)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free
asset, or a scalar numeric with the annual risk-free rate in decimals.}

\item{start_date}{Optional starting date}
}
\value{
An object of class \code{"List"} with the following elements:
\item{strat}{The strat provided to the function}
\item{returns}{An xts object with the daily returns of the strategy}
\item{table_performance}{A table with performance metrics}
\item{rebalance_dates}{Vector of rebalancing dates}
\item{rebalance_weights}{Vector of rebalancing dates}
}
\description{
\code{backtest_allocation} computes a backtest of a given portfolio
allocation rule.
}
\details{
The function first determines the rebalancing dates based
on \code{strat$rebalance_frequency}. Then, it cycles through intermediate
dates and calculates daily returns based on the allocation. If the optional
parameter \code{start_date} is provided, the backtest will start on that
date. Otherwise, it will start from the date from which data on all assets
becomes available.
}
\examples{
# Example 1: backtesting one of the asset allocations in the package
us_60_40 <- asset_allocations$static$us_60_40
bt_us_60_40 <- backtest_allocation(us_60_40,
                                  ETFs$Prices,
                                  ETFs$Returns,
                                  ETFs$risk_free)

# show table with performance metrics
bt_us_60_40$table_performance
# Example 2: creating and backtesting an asset allocation from scratch

# create a strategy that invests equally in momentum (MTUM), value (VLUE),
# low volatility (USMV) and quality (QUAL) ETFs.

factor_strat  <- list(name = "EW Factors",
                      tickers = c("MTUM", "VLUE", "USMV", "QUAL"),
                      default_weights = c(0.25, 0.25, 0.25, 0.25),
                      rebalance_frequency = "month",
                      portfolio_rule_fn = "constant_weights")

# get data for tickers using getSymbols
factor_ETFs <- get_data_from_tickers(factor_strat$tickers,
                                     starting_date = "2020-01-01")
# backtest the strategy
bt_factor_strat <- backtest_allocation(factor_strat,
                                       factor_ETFs$P,
                                       factor_ETFs$R)
# show table with performance metrics
bt_factor_strat$table_performance
}
