% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_variance.R
\name{min_variance}
\alias{min_variance}
\title{Returns minimum variance portfolio weights on a given date}
\usage{
min_variance(strat, reb_date, P, R, risk_free = NULL)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy.}

\item{reb_date}{A date on which the allocation rule is applied.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free
asset, or a scalar numeric with the annual risk-free rate in decimals.}
}
\value{
A numeric vector of weights after applying the rule.
}
\description{
\code{min_variance} determines asset allocations that minimize the variance
of aportfolio.
}
\details{
The function calculates the covariance matrix of returns using the last two
years (or minimum of one year) of daily returns. It relies on the
\code{minvar} function from the \code{NMOF} package.
}
\examples{
ivy  <- asset_allocations$tactical$ivy
reb_date <- as.Date("2022-03-31")
risk_parity(ivy, reb_date, ETFs$Prices[, ivy$tickers], ETFs$Returns[, ivy$tickers])
}
