% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAX3_main.R
\name{max3}
\alias{max3}
\title{Maximum Test: maximum value of the three Cochran-Armitage
trend tests under the recessive, additive, and dominant models}
\usage{
max3(
  y,
  g,
  covariates = NULL,
  Score.test = TRUE,
  Wald.test = FALSE,
  rhombus.formula = FALSE
)
}
\arguments{
\item{y}{a numeric vector of the observed trait values in which
the \emph{i}th element is for the \emph{i}th subject. The elements
should be \code{0} or \code{1}.}

\item{g}{a numeric vector of the observed genotype values (\code{0}, \code{1},
or \code{2} denotes the number of risk alleles) in which the \emph{i}th
element is for the \emph{i}th subject. The missing value is
represented by \code{NA}. \code{g} has the same length as \code{y}.}

\item{covariates}{a numeric matrix for the covariates used in the
model. Each column is for one covariate. The default is \code{NULL}, that
is, there are no covariates to be adjusted for.}

\item{Score.test}{logical. If \code{TRUE}, the score tests are used. One
of \code{Score.test} and \code{Wald.test} should be \code{FALSE},
and the other should be \code{TRUE}. The default is \code{TRUE}.}

\item{Wald.test}{logical. If \code{TRUE}, the Wald tests are used. One of
\code{Score.test} and \code{Wald.test} should be \code{FALSE},
and the other should be \code{TRUE}. The default is \code{FALSE}.}

\item{rhombus.formula}{logical. If \code{TRUE}, the p-value for the MAX3
is approximated by the rhombus formula. IF \code{FALSE}, the 2-fold
integration is used to calculate the p-value. The default is
\code{FALSE}.}
}
\value{
A list with class "\code{htest}" containing the following components:
\tabular{llll}{
\code{statistic} \tab \tab \tab \cr
\tab \tab \tab the observed value of the test statistic.\cr
\code{p.value} \tab \tab \tab \cr
\tab \tab \tab the p-value for the test.\cr
\code{alternative} \tab \tab \tab \cr
\tab \tab \tab a character string describing the alternative hypothesis.\cr
\code{method} \tab \tab \tab \cr
\tab \tab \tab a character string indicating the type of test performed.\cr
\code{data.name} \tab \tab \tab \cr
\tab \tab \tab a character string giving the names of the data.
}
}
\description{
Conduct MAX3 (the maximal value of the three Cochran-Armitage
trend tests derived for the recessive, additive, and dominant
models) based on the trend tests without the adjustment of the
covariates or based on the Wald tests with the adjustment of the
covariates to test for the association between a single-nucleotide
polymorphism and the binary phenotype.
}
\details{
In an association study, the genetic inheritance models
(recessive, additive, or dominant) are unknown beforehand. This
function can account for the uncertainty of the underlying genetic
models and test for the association between a single-nucleotide
polymorphism and a binary phenotype with or without correcting for
the covariates.
}
\examples{
y <- rep(c(0, 1), 5)
g <- sample(c(0, 1, 2), 10, replace = TRUE)
max3(y, g, covariates = NULL, Score.test = TRUE, Wald.test = FALSE,
       rhombus.formula = FALSE)
max3(y, g, covariates = matrix(sample(c(0,1), 20, replace = TRUE), ncol=2),
       Score.test = TRUE, Wald.test = FALSE, rhombus.formula = FALSE)
}
\references{
Lin Wang, Wei Zhang, and Qizhai Li. AssocTests: An R Package 
for Genetic Association Studies. \emph{Journal of Statistical Software}. 
2020; 94(5): 1-26.

Q Li, G Zheng, Z Li, and K Yu. Efficient Approximation
of P Value of the Maximum of Correlated Tests, with Applications
to Genome-Wide Association Studies. \emph{Annals of Human
Genetics}. 2008; 72(3): 397-406.
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}
