% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelDerivative.R
\name{getObjectTree}
\alias{getObjectTree}
\title{Get the Object Tree of a File.}
\usage{
getObjectTree(guid = NULL, urn = NULL, token = NULL)
}
\arguments{
\item{guid}{A string. GUID retrieved via the \code{\link{getMetadata}}
function.}

\item{urn}{A string. Source URN (objectId) for the file. Note the URN must be
Base64 encoded. To encode the URN, see, for example, the
\code{jsonlite::base64_enc} function.}

\item{token}{A string. Token generated with \code{\link{getToken}} function
with \code{data:read} and \code{data:write} scopes.}
}
\value{
An object containing the object tree for the selected file. the file.
}
\description{
Get the object tree of an uploaded file using the Model Derivative API.
}
\examples{
\dontrun{
# Get the object tree for the "aerial.dwg" svf file
resp <- getObjectTree(guid <- myGuid, urn <- myEncodedUrn, token = myToken)
resp
}
}
\seealso{
\url{https://developer.autodesk.com/en/docs/model-derivative/v2/overview/}
}
