% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelDerivative.R
\name{translateSvf}
\alias{translateSvf}
\title{Translate a File into SVF Format.}
\usage{
translateSvf(urn = NULL, token = NULL)
}
\arguments{
\item{urn}{A string. Source URN (objectId) for the file. Note the URN must be
Base64 encoded. To encode the URN, see, for example, the
\code{jsonlite::base64_enc} function.}

\item{token}{A string. Token generated with \code{\link{getToken}} function
with \code{data:read} and \code{data:write} scopes.}
}
\value{
An object containing the \code{result}, \code{urn}, and additional
  activity information.
}
\description{
Translate an uploaded file into SVF format using the Model Derivative API.
}
\examples{
\dontrun{
# Translate the "aerial.dwg" file into a svf file
myEncodedUrn <- jsonlite::base64_enc(myUrn)
resp <- translateSvf(urn = myEncodedUrn, token = myToken)
}
}
\seealso{
\url{https://developer.autodesk.com/en/docs/model-derivative/v2/overview/}
}
