% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking.R
\name{trackEvent}
\alias{trackEvent}
\alias{trackMetric}
\title{Sends an event or set of metrics to Application Insights}
\usage{
trackEvent(session, name, properties)

trackMetric(session, name, metrics, properties)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}

\item{name}{Name of the event.}

\item{properties}{List of properties to track. \code{appId} and any extras given in
\code{\link{startAzureAppInsights}} is automatically inserted.}

\item{metrics}{Numeric vector of values to calculate summary on. Non-finite values are removed.}
}
\value{
Method sends data to client's browser; returns the sent list, invisibly.
}
\description{
Use \code{trackEvent} for tracking a single event together with any extra properties.

Use \code{trackMetric} to track a summary of some measured metrics.
}
\section{Tracking Metrics}{

Individual measured values are not sent to Application Insights. Instead,
summaries of the values (mean, range, average, standard deviation) are sent.
\emph{Note:} Standard deviation doesn't quite work yet.

Before calculating summaries, non-finite values are removed (see \code{\link[base]{is.finite}}).
If there are no values in \code{metrics}, nothing is sent.
}

