% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_aks_methods.R
\name{delete_aks}
\alias{delete_aks}
\title{Delete an Azure Kubernetes Service (AKS)}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{delete_aks(name, confirm=TRUE, wait=FALSE)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the Kubernetes service.
\item \code{confirm}: Whether to ask for confirmation before deleting.
\item \code{wait}: Whether to wait until the deletion is complete.
}
}

\section{Value}{

NULL on successful deletion.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

rg$delete_aks("mycluster")

}
}
\seealso{
\link{create_aks}, \link{get_aks}

\link{az_kubernetes_service}

\link{kubernetes_cluster} for the cluster endpoint

\href{https://docs.microsoft.com/en-us/azure/aks/}{AKS documentation} and
\href{https://docs.microsoft.com/en-us/rest/api/aks/}{API reference}

\href{https://kubernetes.io/docs/reference/}{Kubernetes reference}
}
