% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_database.R
\docType{class}
\name{az_kusto_database}
\alias{az_kusto_database}
\title{Kusto/Azure Data Explorer database resource class}
\description{
Class representing a Kusto database, exposing methods for working with it.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new storage object. See 'Initialization'.
\item \code{add_principals(...)}: Add new database principals. See \code{Principals} below.
\item \code{remove_principals(...)}: Remove database principals.
\item \code{list_principals()}: Retrieve all database principals, as a data frame.
\item \code{get_query_endpoint()}: Get a query endpoint object for interacting with the database.
\item \code{get_ingestion_endpoint()}: Get an ingestion endpoint object for interacting with the database.
}
}

\section{Initialization}{

Initializing a new object of this class can either retrieve an existing Kusto database, or create a new database on the server. Generally, the best way to initialize an object is via the \code{get_database}, \code{list_databases()} and \code{create_database} methods of the \link{az_kusto} class, which handle the details automatically.
}

\section{Principals}{

This class provides methods for managing the principals of a database.

\code{add_principal} takes the following arguments. It returns a data frame with one row per principal, containing the details for each principal.
\itemize{
\item \code{name}: The name of the principal to create.
\item \code{role}: The role of the principal, for example "Admin" or "User".
\item \code{type}: The type of principal, either "User" or "App".
\item \code{fqn}: The fully qualified name of the principal, for example "aaduser=username@mydomain" for an Azure Active Directory account. If supplied, the other details will be obtained from this.
\item \code{email}: For a user principal, the email address.
\item \code{app_id}: For an application principal, the ID.
}

\code{remove_principal} removes a principal. It takes the same arguments as \code{add_principal}; if the supplied details do not match the actual details for the principal, it is not removed.
}

\examples{
\dontrun{

# recommended way of retrieving a resource: via a resource group object
db <- resgroup$
    get_kusto_cluster("mykusto")$
    get_database("mydatabase")

# list principals
db$list_principals()

# add a new principal
db$add_principal("New User", role="User", fqn="aaduser=username@mydomain")

# get the endpoint
db$get_database_endpoint(use_integer64=FALSE)

}
}
\seealso{
\link{az_kusto}, \link{kusto_database_endpoint},
\link{create_database}, \link{get_database}, \link{delete_database}

\href{https://docs.microsoft.com/en-us/azure/data-explorer/}{Kusto/Azure Data Explorer documentation},
}
