% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{get_kusto_cluster}
\alias{get_kusto_cluster}
\alias{get_azure_data_explorer}
\title{Get existing Kusto/Azure Data Explorer cluster}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{get_kusto_cluster(name, location,
                     node_size="D14_v2")
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the cluster.
}
}

\section{Details}{

This method retrieves an existing Kusto cluster resource.
}

\section{Value}{

An object of class \code{az_kusto} representing the created cluster.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login("myaadtenant")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# get a Kusto cluster
rg$get_kusto_cluster("mykusto")

}
}
\seealso{
\link{create_kusto_cluster}, \link{delete_kusto_cluster}, \link{az_kusto}

\href{https://docs.microsoft.com/en-us/azure/data-explorer/}{Kusto/Azure Data Explorer documentation}
}
