% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{DIC}
\alias{DIC}
\title{Deviance Information Criterion (DIC) for angmcmc objects}
\usage{
DIC(object, form = 1, burnin = 1/3, thin = 1, ...)
}
\arguments{
\item{object}{angular MCMC object.}

\item{form}{form of DIC to use. Available choices are 1 (default) and 2. See details.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{...}{additional model specific arguments to be passed to \code{DIC}. For example, \code{int.displ}
specifies integer dispacement in wnorm and wnorm2 models. See \link{fit_wnormmix} and
\link{fit_wnorm2mix} for more details.}
}
\value{
Computes the DIC for a given angmcmc object
}
\description{
Deviance Information Criterion (DIC) for angmcmc objects
}
\details{
Given a deviance function \eqn{D(\theta) = -2 log(p(y|\theta))}, and an estimate
\eqn{\theta* = (\sum \theta_i) / N} of the posterior mean
\eqn{E(\theta|y)}, where \eqn{y} denote the data, \eqn{\theta} are the unknown
parameters of the model, \eqn{\theta_1, ..., \theta_N} are MCMC samples from the posterior
distribution of \eqn{\theta} given \eqn{y} and \eqn{p(y|\theta)} is the likelihood function,
the (form 1 of) Deviance Infomation Criterion (DIC) is defined as
\deqn{DIC = 2 ( (\sum_{s=1}^N D(\theta_s)) / N - D(\theta*) )}
The second form for DIC is given by
\deqn{DIC = D(\theta*) - 4 \hat{var} \log p(y|\theta_s)}
where for \eqn{i = 1, ..., n}, \eqn{\hat{var} \log p(y|\theta)} denotes the estimated variance
of the log likelihood based on the realizations \eqn{\theta_1, ..., \theta_N}.

Like AIC and BIC, DIC is an asymptotic approximation for large samples, and
is only valid when the posterior distribution is approximately normal.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
DIC(fit.vmsin.20)

}
