% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{summary.angmcmc}
\alias{summary.angmcmc}
\title{Summary statistics for parameters from an angmcmc object}
\usage{
\method{summary}{angmcmc}(object, burnin = 1/3, thin = 1, ...)
}
\arguments{
\item{object}{angular MCMC object.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
Returns a list with elements \code{estimate, lower, upper, llik} and \code{lpd}.
}
\description{
Summary statistics for parameters from an angmcmc object
}
\details{
Computes (after thinning and discarding burn-in) point estimates with 95\% posterior credible sets for all components and all parameters,
together with the sample averages of log likelihood and log posterior density.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
summary(fit.vmsin.20)

}
