% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{paramtrace}
\alias{paramtrace}
\title{Trace plot for parameters from an angmcmc object}
\usage{
paramtrace(object, par, comp.label, burnin = 1/3, thin = 1)
}
\arguments{
\item{object}{angular MCMC object.}

\item{par}{parameter for which trace plot is to be created.}

\item{comp.label}{vector of component labels (positive integers, e.g., \code{1, 2, ...}) for which point estimates are to be computed.
If \code{NULL}, results for all components are provided.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}
}
\value{
Returns a single plot if a single \code{par} and a single \code{comp.label} is supplied.
Otherwise, a series of plots is produced.
}
\description{
Trace plot for parameters from an angmcmc object
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
# trace plot for kappa1 in component 1
paramtrace(fit.vmsin.20, "kappa1", 1)
# for kappa1 in all components
paramtrace(fit.vmsin.20, "kappa1")
# for all parameters in component 1
paramtrace(fit.vmsin.20, comp.label = 1)

}
