% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.Fast.R
\name{Networks.Fast}
\alias{Networks.Fast}
\title{Fast Algorithm for Bayesian Network Discovery}
\usage{
Networks.Fast(pvalue, net, iter = 5000, nburns = 2000,
  algorithms = c("EM", "DPM"), v = 20, DPM.mcmc = list(nburn = 2000, nsave
  = 1, nskip = 0, ndisplay = 10), DPM.prior = list(a0 = 2, b0 = 1, m2 = rep(0,
  1), s2 = diag(1e+05, 1), psiinv2 = solve(diag(0.5, 1)), nu1 = 4, nu2 = 4, tau1
  = 1, tau2 = 100), DPparallel = FALSE, n.cores = 1, piall = c(0.8, 0.85,
  0.9, 0.95), rhoall = c(1, 2, 5, 10, 15), show.steps = 10,
  showlikelihood = FALSE, likelihood.frequency = 100)
}
\arguments{
\item{pvalue}{a vector of p-values obtained from large scale statistical hypothesis testing}

\item{net}{a n by n network configuration, n is the length of pvalue}

\item{iter}{number of iterations. The default is 5000}

\item{nburns}{number of burn-in. The default is 2000}

\item{algorithms}{vector, either "EM" or "DPM"}

\item{v}{number of iterations set for DPM fitting by "DPdensity". v is only valid when you choose initals as "DPdensity"}

\item{DPM.mcmc}{a list}

\item{DPM.prior}{a list}

\item{DPparallel}{logical.}

\item{n.cores}{number of cores}

\item{piall}{a vector of selections of pi0. The default vector is 0.75, 0.8, 0.85, 0.9. The selections of pi0 should be placed in sequence, from smaller to larger.}

\item{rhoall}{a vector of selections of rho0 and rho1. The default vector is 1, 2, 5, 10, 15. The selections of rho0 and rho1 should be placed in sequence, from smaller to larger.}

\item{show.steps}{number, default=10}

\item{showlikelihood}{logical, default=FALSE}

\item{likelihood.frequency}{number, default=100}
}
\value{
a list cantaining Bayesian Statistics information of the distribution of zi
\describe{
\item{trace}{a n by (iter-nburns) matrix (n is the length of elements and iter-nburns is the length of the saved chain), showing the evolution of the chain for each element}
\item{mean}{the mean of the distribution for each element}
\item{median}{the median of the distribution for each element}
\item{var}{the variance of the distribution for each element}
\item{quantile}{the quantiles of the distribution for each element}
}
}
\description{
Fast Algorithm for Bayesian Network Discovery
}
\details{
This generic function fits a Bayesian Nonparametric Mixture Model for gene selection incorporating network information (Zhao et al., 2014):
\itemize{
\item  r_i| g_i, \strong{theta} ~ N(mu_{g_i}, sigma_{g_i}),
\item  g_i | z_i=k, \strong{q}_k ~ Discrete(\strong{a}_k, \strong{q}_k),
\item	\strong{theta} ~ G_{0k}, for g in \strong{a}_k,
\item	\strong{q}_k ~ Dirichlet(tau_k \strong{1}_{L_k}/L_k),
\item	\strong{theta}={\strong{theta}_g}_{g in \strong{a}_0 and \strong{a}_1} 
\item	\strong{theta}_g=(mu_g, sigma_g)
}
where we define 
\describe{
\item{Index}{\strong{a}_0=(-L_0+1,-L_0+2,...,0) , \strong{a}_1=(1,2,...,L_1) and the correspondent probability q_0=(q_{-L_0+1}, q_{-L_0+2}, ...,q_0), q_1=(q_1, q_2, ..., q_{L_1}), according to the defination of Discrete(\strong{a}_k, \strong{b}_k), for example, Pr(g_i={L_0+2})=q_{-L_0+2}. }
\item{Assumption}{We have an assumption that "selected" gene or image pixel should have larger statiscs comparing to "unselected" ones without the loss of generality. In this regard, we set the restriction mu_g<mu_{g+1} for g=-L_0+1, -L_0+2,...,L_1.}
}
For this function, The NET-DPM-3, considered as Fast function is applied , and more details about the algorithm can be referred from Appnendix B.3 of Zhao et al., 2014
}
\examples{
\dontrun{
####Example1. For a 10X10 image with 5X5 signal for example
##Creating the network of 10X10 image
library(igraph)
library(BayesNetDiscovery)
g <- graph.lattice(length=10,dim=2)
##the input of argument \\code{net}
net=as(get.adjacency(g,attr=NULL),"matrix")
## Assign the signal elements with signal intenstion as normal distribution N(1,0.2). 
## While noise is set as N(0,0.2) 
newz=rep(0,100)
for (i in 3:7)
{
 newz[(i*10+3):(i*10+7)]=1
}
testcov<-0
for(i in 1:100){
 if(newz[i]==0){
   testcov[i]<-rnorm(1,mean=0,sd=0.2)
 }else{
  testcov[i]<-rnorm(1,mean=1,sd=0.2)
 }
}
##The profile of the impage
image(matrix(testcov,10,10),col=gray(seq(0,1,length=255)))
##Transform the signals into pvalue form and begin identification
pvalue=pnorm(-testcov)
total2=Networks.Fast(pvalue,net,iter=5000,piall=c(0.8, 0.85, 0.9, 0.95),
rhoall=c(0.5,1,5,10,15))




####Example.2 Gene Network discovery
##Generating Scale free Gene Network
library(igraph)
library(BayesNetDiscovery)
g <- barabasi.game(50, power=1, zero.appeal=1.5,directed = F)
tkplot(g, layout=layout.kamada.kawai)
net=as(get.adjacency(g,attr=NULL),"matrix")
##Random assign selected genes and make the signal intension as gaussian mixture
newz=rep(c(1,0,0,1,0),10)
Simnorm=function(n){
  weight = c(0.4, 0.6)
  mu = c(5,4)
  sigma = c(1,0.5)
  z = sample(c(1,2),size=n, prob=weight,replace=TRUE)
  r = rnorm(n,mean=mu[z],sd=sigma[z])
  return(r)
}
testcov<-0
for(i in 1:50){
  if(newz[i]==0){
    testcov[i]<-rnorm(1,mean=0,sd=1)
   }else{
  testcov[i]<-Simnorm(1)
  }
}
pvalue=pnorm(-testcov)
total1=Networks.Fast(pvalue,net,iter=5000,v=20,piall=c(0.8, 0.85, 0.9, 0.95),
rhoall=c(1, 2, 5, 10, 15))
}
}
