% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{alpha.estimate}
\alias{alpha.estimate}
\title{Alpha diversity estimates.}
\usage{
alpha.estimate(comm, tree, func = "nonparametric")
}
\arguments{
\item{comm}{A sites x species matrix, with either abundances or number of incidences.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree.}

\item{func}{The class of estimators to be used:
If func is partial match of "nonparametric", TD, PD or FD are based on non-parametric estimators.
If func is partial match of "completeness", PD or FD estimates are based on the completeness of TD (requires a tree to be used).
If not specified, default is "nonparametric".}
}
\value{
A matrix of sites x diversity values (individuals, observed and estimated diversity).
The values provided by this function are:

Ind - Number of individuals;

Obs - Observed diversity;

S1 - Singletons;

S2 - Doubletons;

Jack1ab - First order jackknife estimator for abundance data;

Jack2ab - Second order jackknife estimator for abundance data;

Chao1 - Chao estimator for abundance data.

The P-corrected version of all estimators is also provided.
}
\description{
Estimation of alpha diversity of multiple sites simultaneously.
}
\details{
Observed diversity often is an underestimation of true diversity.
Non-parametric estimators based on the incidence or abundance of rare species have been proposed to overcome the problem of undersampling (Heltshe & Forrester 1983; Chao 1984, 1987; Colwell & Coddington 1994).
A correction to non-parametric estimators has also been recently proposed, based on the proportion (P) of singleton or unique species
(species represented by a single individual or in a single sampling unit respectively; Lopez et al. 2012).
Cardoso et al. (2014) have proposed a way of adapting non-parametric species richness estimators to PD and FD. They have also proposed correcting PD and FD values based on the completeness of TD, where completeness equals the proportion of estimated true diversity that was observed.
Calculations of PD and FD are based on Faith (1992) and Petchey & Gaston (2002, 2006), which measure PD and FD of a community as the total branch length of a tree linking all species represented in such community.
PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric). The path to the root of the tree is always included in calculations of PD and FD.
The number and order of species in comm must be the same as in tree.
}
\examples{
comm <- matrix(c(1,1,0,0,0,0,2,1,0,0,0,0,2,1,0,0,0,0,2,1), nrow = 4, ncol = 5, byrow = TRUE)
tree <- tree.build(dist(c(1:5)))
alpha.estimate(comm)
alpha.estimate(comm, tree)
alpha.estimate(comm, tree, func = "completeness")
}
\references{
Cardoso, P., Rigal, F., Borges, P.A.V. & Carvalho, J.C. (2014) A new frontier in biodiversity inventory: a proposal for estimators of phylogenetic and functional diversity. Methods in Ecology and Evolution, 5: 452-461.

Chao, A. (1984) Nonparametric estimation of the number of classes in a population. Scandinavian Journal of Statistics, 11, 265-270.

Chao, A. (1987) Estimating the population size for capture-recapture data with unequal catchability. Biometrics 43, 783-791.

Colwell, R.K. & Coddington, J.A. (1994) Estimating terrestrial biodiversity through extrapolation. Phil. Trans. Roy. Soc. London B 345, 101-118.

Faith, D.P. (1992) Conservation evaluation and phylogenetic diversity. Biological Conservation, 61, 1-10.

Heltshe, J. & Forrester, N.E. (1983) Estimating species richness using the jackknife procedure. Biometrics, 39, 1-11.

Lopez, L.C.S., Fracasso, M.P.A., Mesquita, D.O., Palma, A.R.T. & Riul, P. (2012) The relationship between percentage of singletons and sampling effort: a new approach to reduce the bias of richness estimates. Ecological Indicators, 14, 164-169.

Petchey, O.L. & Gaston, K.J. (2002) Functional diversity (FD), species richness and community composition. Ecology Letters, 5, 402-411.

Petchey, O.L. & Gaston, K.J. (2006) Functional diversity: back to basics and looking forward. Ecology Letters, 9, 741-758.
}
