% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{ses}
\alias{ses}
\title{Standard Effect Size.}
\usage{
ses(obs, est, param = TRUE, p = TRUE)
}
\arguments{
\item{obs}{A single observed value.}

\item{est}{A vector with estimated values.}

\item{param}{Value is calculated with parametric or non-parametric method. Because standardized effect sizes may lead to biased conclusions if null values show an asymmetric distribution or deviate from normality, non-parametric effect sizes use probit transformed p-values (Lhotsky et al., 2016).}

\item{p}{Boolean indicating whether the p-value should be returned.}
}
\value{
The ses value or a vector with ses and p-value.
}
\description{
Calculates the standard effect size from observed and estimated values.
}
\examples{
est = rnorm(1000, 500, 100)

ses(100, est)
ses(100, est, param = FALSE)
ses(500, est)
ses(500, est, param = FALSE)
ses(900, est, p = TRUE)
ses(900, est, param = FALSE, p = TRUE)
}
\references{
Lhotsky et al. (2016) Changes in assembly rules along a stress gradient from open dry grasslands to wetlands. Journal of Ecology, 104: 507-517.
}
