% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_prepare_data_to.R
\name{do_prepare_data_to}
\alias{do_prepare_data_to}
\title{Prepare data for the timeouts computation}
\usage{
do_prepare_data_to(data, rm_overtime, data_ginfo, data_gcoach)
}
\arguments{
\item{data}{Source play-by-play data from a given game.}

\item{rm_overtime}{Logical. Decide to remove overtimes or not.}

\item{data_ginfo}{Games' basic information.}

\item{data_gcoach}{Coach of each team in each day.}
}
\value{
Data frame. Each row represents the action happened in the game. 
The \strong{team} column refers in this case both to the team to 
which the player belongs and the coach of that team. In addition,
a \strong{points} column is added to transform the action
that finished in scoring into numbers .
}
\description{
The computation of the successful timeouts requires a specific data
preparation. This function does this data processing.
}
\note{
1. Actions are given in Spanish. A bilingual basketball vocabulary (Spanish/English)
is provided in \url{https://www.uv.es/vivigui/docs/basketball_dictionary.xlsx}.

2. The \strong{game_code} column allows us to detect the source website, for example,
\url{https://jv.acb.com/es/103389/jugadas}.
}
\examples{
df0 <- acb_vbc_cz_pbp_2223

df1 <- do_prepare_data_to(df0, TRUE, acb_games_2223_info, acb_games_2223_coach)
#df1                        

}
\seealso{
\code{\link{do_time_out_success}}
}
\author{
Guillermo Vinue
}
