% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_2_pcor.R
\name{cor_2_pcor}
\alias{cor_2_pcor}
\title{Correlation to Partial Correlation}
\usage{
cor_2_pcor(x, ...)
}
\arguments{
\item{x}{An object of class \code{bbcor}}

\item{...}{Currently ignored

\itemize{
\item \code{pcor_mean}: A matrix including the posterior mean.

\item \code{samps}: An array of dimensions \code{p} by \code{b} by \code{iter} that includes the 
sampled partial correlation matrices.
}}
}
\description{
Convert correlations into the corresponding partial correlations.
}
\examples{
Y <- mtcars[,1:3]

fit <- bbcor(Y, method = "spearman")

cor_2_pcor(fit)

}
