% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgeomBCD.R
\name{dgeomBCD}
\alias{dgeomBCD}
\title{Joint Probability Mass Function for A Bivariate Geometric Distribution via Conditional Specification}
\usage{
dgeomBCD(x, y, q1, q2, q3)
}
\arguments{
\item{x}{value of \eqn{ X } that must be non-negative integer}

\item{y}{value of \eqn{ Y } that must be non-negative integer}

\item{q1}{probability parameter for \eqn{ X }, in \eqn{(0, 1]}}

\item{q2}{probability parameter for \eqn{ Y }, in \eqn{(0, 1]}}

\item{q3}{dependence parameter, in \eqn{(0, 1]}}
}
\value{
The probability \eqn{ P(X = x, Y = y) } for each pair of \eqn{ x } and \eqn{ y }.
}
\description{
Computes the joint probability mass function (p.m.f.) of a Bivariate Geometric Conditional Distributions (BGCD) based on Ghosh, Marques, and Chakraborty (2023). This distribution models paired count data with geometric conditionals, incorporating dependence between variables \eqn{ X } and \eqn{ Y }.
}
\details{
The joint p.m.f. of the BGCD is:
\deqn{
P(X = x, Y = y) = K(q_1, q_2, q_3) q_1^x q_2^y q_3^{xy},
}
where \eqn{ K(q_1, q_2, q_3) } is the normalizing constant computed by the function \code{normalize_constant_BGCD}.

Note that:

- \eqn{ q_3 < 1 } :  indicates the negative correlation between \eqn{X} and \eqn{Y}

- \eqn{ q_3 = 1 } : indicates the independence between \eqn{X} and \eqn{Y}
}
\examples{
# Compute P(X = 1, Y = 2) with q1 = 0.5, q2 = 0.6, q3 = 0.8
dgeomBCD(x = 1, y = 2, q1 = 0.5, q2 = 0.6, q3 = 0.8)

# # Compute P(X = 0, Y = 4) with q1 = 0.5, q2 = 0.6, q3 = 0.8
dgeomBCD(x = 0, y = 4, q1 = 0.5, q2 = 0.6, q3 = 0.8)

}
\references{
Ghosh, I., Marques, F., & Chakraborty, S.(2023) A bivariate geometric distribution via conditional specification: properties and applications, Communications in Statistics - Simulation and Computation, 52:12, 5925--5945, \doi{10.1080/03610918.2021.2004419}
}
\seealso{
\code{\link{pgeomBCD}} \code{\link{rgeomBCD}} \code{\link{MLEgeomBCD}}
}
