% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEIDList.R
\name{BEIDList}
\alias{BEIDList}
\title{Create a BEIDList}
\usage{
BEIDList(l, metadata, scope)
}
\arguments{
\item{l}{a named list of BEID vectors}

\item{metadata}{a data.frame with rownames or
a column "\strong{.lname}" all in names of l.
If missing, the metadata is constructed with \strong{.lname} being the names
of l.}

\item{scope}{a list with 3 character vectors of length one named "be",
"source" and "organism".
If missing, it is guessed from l.}
}
\value{
A BEIDList object which is a list of BEID vectors with 2 additional
attributes:
\itemize{
\item \strong{metadata}: a data.frame with metadata about list elements.
The "\strong{.lname}" column correspond to the names of the BEIDList.
\item \strong{scope}: the BEID scope ("be", "source" and "organism")
}
}
\description{
Create a BEIDList
}
\examples{
\dontrun{
bel <- BEIDList(
   l=list(
      kinases=c("117283", "3706", "3707", "51447", "80271", "9807"),
      phosphatases=c(
         "130367", "249", "283871", "493911", "57026", "5723", "81537"
      )
   ),
   scope=list(be="Gene", source="EntrezGene", organism="Homo sapiens")
)
scope(bel)
metadata(bel)
metadata(bel) <- dplyr::mutate(
   metadata(bel),
   "description"=c("A few kinases", "A few phosphatases")
)
metadata(bel)
}

}
