% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEDMatrix.R, R/package.R
\docType{package}
\name{BEDMatrix}
\alias{BEDMatrix}
\alias{BEDMatrix-package}
\title{Creates a matrix wrapper around a binary PED file.}
\usage{
BEDMatrix(path, n = NULL, p = NULL)
}
\arguments{
\item{path}{Path to the binary PED file.}

\item{n}{The number of individuals. Optional if FAM file of same name as BED
file exists.}

\item{p}{The number of markers. Optional if MAP file of same name as BED file
exists.}
}
\description{
The binary PED file will not be loaded into memory. Rather, subsets are
extracted 'on the fly'.

The BEDMatrix package provides a wrapper around binary PED files (so-called
BED files) that behaves just like a regular R matrix, but retrieves
genotypes on demand without loading the entire BED file into memory. The
goal is to support huge PED files, and to save time on initially reading in
PED files into the R environment.
}
\details{
If a FAM or MAP file with the same name as the binary PED file (minus the
extension) exists within the same folder, \code{n} and \code{p} as well as
rownames and colnames will be automatically determined from those files.
To skip this, provide \code{n} and \code{p} manually.
}

