% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FUNCTIONS_test_statistics.R
\name{BFF_F_test}
\alias{BFF_F_test}
\title{BFF_F_test}
\usage{
BFF_F_test(f_stat, df1, df2, n, savename = NULL)
}
\arguments{
\item{f_stat}{F statistic}

\item{df1}{Degrees of freedom}

\item{df2}{Degrees of freedom}

\item{n}{Sample size}

\item{savename}{Name of pdf file to save. Requires .pdf extension. Required if saving plot}
}
\value{
Returns Bayes factor function results
 \tabular{ll}{
   \code{BFF} \tab Bayes Factor Function values \cr
   \tab \cr
   \code{effect_size} \tab Effect sizes tested (seq(0, 1, by = 0.01)) \cr
   \tab \cr
   \code{max_BFF} \tab Maximum BFF value \cr
   \tab \cr
   \code{max_RMSE} \tab Effect size that maximizes BFF\cr
}
}
\description{
Bayes Factor function test for the F statistic. Computes the Bayes factor in favor of the
alternative given an F statistic, the degrees of freedom, and sample size. The plot shown
when running the function is saved to "BFF_plot.pdf."
}
\examples{
BFF_F_test(f_stat = 4.6, df1 = 4, df2 = 10, n = 100)
}
