% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FUNCTIONS_test_statistics.R
\name{BFF_z_test}
\alias{BFF_z_test}
\title{BFF_z_test}
\usage{
BFF_z_test(
  z_stat,
  n = NULL,
  one_sample = TRUE,
  n1 = NULL,
  n2 = NULL,
  savename = NULL
)
}
\arguments{
\item{z_stat}{t statistic}

\item{n}{Sample size}

\item{one_sample}{Is this a one or two sample z-test? Default is FALSE}

\item{n1}{Sample size of group 1 if one_sample is FALSE}

\item{n2}{Sample size of group 2 if one_sample is FALSE}

\item{savename}{Name of pdf file to save. Requires .pdf extension. Required if saving plot}
}
\value{
Returns Bayes factor function results
 \tabular{ll}{
   \code{BFF} \tab Bayes Factor Function values \cr
   \tab \cr
   \code{effect_size} \tab Effect sizes tested (seq(0, 1, by = 0.01)) \cr
   \tab \cr
   \code{BFF_max_RMSE} \tab Maximum BFF value \cr
   \tab \cr
   \code{max_RMSE} \tab Effect size that maximizes BFF\cr
}
}
\description{
Bayes Factor function test for the t statistic. Computes the Bayes factor in favor of the
alternative given a z statistic and sample size. The plot shown
when running the function is saved to "BFF_plot.pdf."
}
\examples{
BFF_z_test(1.4, 500)
}
