% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfs_download_asset.R
\name{bfs_download_asset}
\alias{bfs_download_asset}
\title{Download a BFS asset file}
\usage{
bfs_download_asset(
  number_asset = NULL,
  number_bfs = NULL,
  destfile,
  quiet = TRUE,
  mode = "wb",
  handle = curl::new_handle()
)
}
\arguments{
\item{number_asset}{The asset number of a dataset}

\item{number_bfs}{The BFS number of a dataset.}

\item{destfile}{A character string with the name where the downloaded file is saved. Tilde-expansion is performed.}

\item{quiet}{If TRUE, suppress status messages (if any), and the progress bar.}

\item{mode}{A character string specifying the mode with which to write the file. Useful values are "w", "wb" (binary), "a" (append) and "ab".}

\item{handle}{a curl handle object}
}
\value{
Returns the file path where the file has been downloaded
}
\description{
This function uses the DAM API
\url{https://dam-api.bfs.admin.ch/hub/swagger-ui/index.html}
to download a BFS file by asset number or BFS number. The file is downloaded
using `curl::curl_download()` under the hood.
}
