% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_taxonomy_genus}
\alias{BIEN_taxonomy_genus}
\title{Extract taxonomic information for genera}
\usage{
BIEN_taxonomy_genus(genus, print.query = FALSE, ...)
}
\arguments{
\item{genus}{A single genus or a vector of genera.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Dataframe containing taxonomic information for the specified genera.
}
\description{
BIEN_taxonomy_genus downloads a dataframe of all taxonomic information for given genera.
}
\examples{
\dontrun{
BIEN_taxonomy_genus("Acer")
genus_vector<-c("Acer","Quercus")
BIEN_taxonomy_genus(genus_vector)}
}
\seealso{
Other taxonomy functions: \code{\link{BIEN_taxonomy_family}},
  \code{\link{BIEN_taxonomy_species}}
}

