% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResponseSurface-methods.R
\name{plot.ResponseSurface}
\alias{plot.ResponseSurface}
\title{Method for plotting response surface objects}
\usage{
\method{plot}{ResponseSurface}(
  x,
  color = c("z-score", "maxR", "occupancy", "effect-size"),
  greyScale = FALSE,
  ...
)
}
\arguments{
\item{x}{Output of \code{\link{fitSurface}}}

\item{color}{Character indicating on what values surface coloring will be
based.

If \code{color = "z-score"}, surface coloring will be based on median of
standardized off-axis Z-scores. Median function can be replaced by other
function using an optional \code{colorfun} argument which will be passed to
\code{plotResponseSurface}. Color breaks are determined here by standard
deviation of off-axis Z-scores. For \code{color = "maxR"}, coloring will be
based on values of maxR statistic and the quantile of its distribution
(bootstrapped or not). If \code{color = "occupancy"}, coloring will be
based on calculated occupancy rate for the respective dose combination.
If \code{color = "effect-size"}, coloring will be
based on effect size for the respective dose combination.}

\item{greyScale}{If \code{greyScale = TRUE}, then plot is in grey scale,
otherwise in colour.}

\item{...}{Further parameters passed to \code{\link{plotResponseSurface}}.
\code{colorBy} argument in this method is computed automatically and thus
cannot be passed to \code{\link{plotResponseSurface}}.}
}
\description{
Method for plotting response surface objects
}
