% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGrid.r
\name{makeGrid}
\alias{makeGrid}
\title{Make a grid}
\usage{
makeGrid(
  polygon,
  gridSize,
  buffer = FALSE,
  hexGrid = TRUE,
  offset = NULL,
  simplify = FALSE,
  tol = 0.01
)
}
\arguments{
\item{polygon}{an object of class \sQuote{SpatialPolygon} or
\sQuote{SpatialPolygonDataFrame}}

\item{gridSize}{width of the cells in Km. It defines the central assumption
of this package that is the maximum area a person can explore during a day.
Be aware, that the spatial extent of a visit is dependent on the taxonomic group, and many other variables.
Maximum recomended for this package 10 km if there is no reliable definition
for the spatial extent for visits.}

\item{buffer}{shall the grid cells include the polygon border? Then \code{TRUE}
(default = \code{FALSE}).}

\item{hexGrid}{shall the grid cells be hexagonal? Then \code{TRUE} (default).
Else squared grid cells.}

\item{offset}{the offset (position) of the grid (from \code{spsample} methods).
If it is left empty (\code{NULL}, default), then takes default values.
For squared grid cells the default is set to \code{c(0.5,0.5)} ("centric systematic").
For hexagonal grid cells the default is set to \code{c(0,0)}.}

\item{simplify}{simplifies the polygon geometry using the Douglas-Peuker algorithm  (from rgeos package).
Complicated polygons (those with much detail) make this function run slower.}

\item{tol}{numerical tolerance value for the simplification algorith. Set to 0.01 as default.}
}
\value{
an object of class \sQuote{SpatialPolygon} with a set of polygons
conforming to a grid of equal-area cells, with geodesic coordinates in WGS84 (ESPG:4326).
}
\description{
Makes a grid adapted to the purpose of this package and simplifing options
from the  \code{sp} package. The central concept of the BIRDS package is the
definition of the field visit, and most likely, your grid size will define the
maximum area a person can explore during a day. Use the function
\code{exploreVisits()} to assess if your definition of visit aligns with your
 grid size.
}
\note{
Depending on the total number of grid cells the computations may take time.
If there are more than 100 cells on any dimension a warning message will be displayed.
Grid cells must be smaller than the sampling area. If the grid cell size is wider than the polygon on any dimension
an error message will be displayed.
}
\examples{
grid <- makeGrid(gotaland, gridSize = 10)
}
\seealso{
\code{\link{drawPolygon}}, \code{\link{renameGrid}}, \code{\link{OB2Polygon}}, \code{\link{exploreVisits}}
}
