% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focalSpecies.R
\name{speciesSummary}
\alias{speciesSummary}
\title{Summarize all records for a species}
\usage{
speciesSummary(x)
}
\arguments{
\item{x}{an object of class \sQuote{SummarizeBirds}.}
}
\value{
a \code{data.frame} with summary data for each species
}
\description{
A function that counts the number of observations, number of visits and number of grid cells with occurrences for all species.
}
\examples{
\donttest{
grid <- makeGrid(searchPolygon, gridSize = 10)
SB <- summarizeBirds(organizeBirds(bombusObsShort), grid=grid)
summSB <- speciesSummary(SB)
}
}
\seealso{
\code{\link{summarizeBirds}}, \code{\link{exportBirds}}
}
