% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{get_tp_local_test_results}
\alias{get_tp_local_test_results}
\title{Transition Probabilities: Local Tests for a Specific Covariate}
\usage{
get_tp_local_test_results(
  results,
  cov,
  delta,
  all_cov_labels = NULL,
  state_labels = 1:results$Num_States,
  other_cov_levels = NULL,
  comp_pairs = NULL,
  decimal_pts = 2,
  include_plot = TRUE
)
}
\arguments{
\item{results}{results of transition probabilities, i.e., results$results_trans}

\item{cov}{the index of the covariate to perform local tests on}

\item{delta}{threshold for the null hypothesis H_0; see Details}

\item{all_cov_labels}{a matrix such that row i represents the labels for covariate i; default labels for covariate i is 1:i}

\item{state_labels}{a vector of strings that represent the state labels; default is 1:Num_States}

\item{other_cov_levels}{a matrix such that each row is a combination of covariate levels excluding 'cov'; default is all possible combinations of covariates excluding 'cov'}

\item{comp_pairs}{a matrix such that each row is a pair of levels of 'cov' to compare}

\item{decimal_pts}{specify the number of decimal points of the results; default is 2}

\item{include_plot}{display plot if TRUE; default is TRUE}
}
\value{
No return value, called for printing and plotting local test results for transition probabilities.
}
\description{
Given some covariate 'cov' and the levels of other covariates,
prints and plots the local test results for pairs of levels of 'cov',
including the absolute differences in transition probabilities,
and the probabilities for the null hypothesis.
}
\details{
Fix a covariate i as the target of the local test. \cr
The function provides two matrices of size d0xd0 where d0 is the number of states: \cr
(1) the mean of the absolute difference in all transition types for each pair of levels of covariate i; \cr
(2) the probability of the null hypothesis of the local test for all transition types.

Given a pair of levels of covariate i, say i_1 and i_2, and given the levels of other covariates,
the null hypothesis is that the difference between i_1 and i_2 is not significant for transition probabilities.
It is calculated as the percentage of the samples with absolute difference less than 'delta'.

'comp_pairs' are user-specified pairs of 'cov' for the local test.
Each row of 'comp_pairs' is a pair of indices of 'cov'.
}
\examples{

# Examples using the shortened built-in simulated Foxp2 data set, foxp2_sm
# recall the covariate labels are: ("HET","WT") and ("U","L","A")

results <- BMRMM(foxp2_sm,num_cov=2,duration_type='None',simsize=50)

# results for genotypes (HET, WT) under all three social contexts
get_tp_local_test_results(results$results_trans,cov=1,delta=0.02)

# results for genotypes (HET, WT) under social contexts U and A
get_tp_local_test_results(results$results_trans,cov=1,delta=0.02,
                          other_cov_levels=matrix(c(1,3),nrow=2))

# results for contexts (U,L), (U,A) and (L,A) under two genotypes
get_tp_local_test_results(results$results_trans,cov=2,delta=0.02)

# results for contexts (U,L), (U,A) under genotype HET (specify pairs)
get_tp_local_test_results(results$results_trans,cov=2,delta=0.02,
                          other_cov_levels=matrix(1,nrow=1),
                          comp_pairs=matrix(c(1,2,1,3),nrow=2,byrow=2))

}
