% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF_plots.R
\name{plotGOF_noncensored}
\alias{plotGOF_noncensored}
\title{Plot Goodness of fits graphical checks for non censored data}
\usage{
plotGOF_noncensored(fit, qq_plot = FALSE, thinning_to = 500)
}
\arguments{
\item{fit}{The result of the fit, obtained through the function MixNRMI1 or MixNRMI2, MixNRMI1cens or MixNRMI2cens}

\item{qq_plot}{Whether to compute the QQ-plot}

\item{thinning_to}{How many iterations to compute the mean posterior quantiles}
}
\value{
A density plot with histogram, a cumulative density plot with the empirical cumulative distribution, and a percentile-percentile plot.
}
\description{
Plot Goodness of fits graphical checks for non censored data
}
\examples{
set.seed(150520)
data(acidity)
out <- MixNRMI1(acidity, extras = TRUE, Nit = 100)
BNPdensity:::plotGOF_noncensored(out)
}
