% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PYregression.R
\name{PYregression}
\alias{PYregression}
\title{MCMC for Pitman-Yor mixture of Gaussian regressions}
\usage{
PYregression(y, x, mcmc = list(), prior = list(), output = list())
}
\arguments{
\item{y}{a vector of observations, univariate dependent variable;}

\item{x}{a vector of observations, univariate independent variable;}

\item{mcmc}{a list of MCMC arguments:
\itemize{
  \item \code{niter} (mandatory), number of iterations.

  \item \code{nburn} (mandatory), number of iterations to discard as burn-in.

  \item \code{method}, the MCMC sampling method to be used. Options are \code{'ICS'}, \code{'MAR'} and \code{'SLI'} (default is \code{'ICS'}). See details.

  \item \code{nupd}, argument controlling the number of iterations to be displayed on screen: the function reports
  on standard output every time \code{nupd} new iterations have been carried out (default is \code{niter/10}).

  \item \code{print_message}, control option. If equal to \code{TRUE}, the status is printed
  to standard output every \code{nupd} iterations (default is \code{TRUE}).

  \item \code{m_imp}, number of generated values for the importance sampling step of \code{method = 'ICS'} (default is 10). See details.

  \item \code{slice_type}, when \code{method = 'SLI'} it specifies the type of slice sampler. Options are \code{'DEP'} for dependent slice-efficient, and \code{'INDEP'} for independent slice-efficient (default is \code{'DEP'}). See details.

  \item \code{m_marginal}, number of generated values for the augmentation step needed, if \code{method = 'MAR'}, to implement Algorithm 8 of Neal, 2000. (Default is 100). See details.

  \item \code{hyper}, if equal to \code{TRUE}, hyperprior distributions on the base measure's
  parameters are added, as specified in \code{prior} and explained in \code{details} (default is \code{TRUE}).
}}

\item{prior}{a list giving the prior information. The list includes
\code{strength} and \code{discount}, the strength and discount parameters of the Pitman-Yor process
(default are \code{strength = 1} and \code{discount = 0}, the latter leading to the Dirichlet process).
The remaining parameters specify the base measure: \code{m0} and \code{S0} are
 the mean and covariance of normal base measure on the regression coefficients (default are a vector of zeroes and the identity matrix);
 \code{a0} and \code{b0} are the shape and scale parameters of the inverse gamma base measure on the scale component
 (default are 2 and 1).
 If \code{hyper = TRUE},  optional hyperpriors on the base measure's parameters are added:
 specifically, \code{m1} and \code{k1} are the  mean parameter and scale factor defining the
 normal hyperprior on \code{m0} (default are a vector of zeroes and 1);
 \code{tau1} and \code{zeta1} are the shape and rate parameters of the gamma hyperprior on
 \code{b0} (default is 1 for both);
 \code{n1} and \code{S1} are the parameters (degrees of freedom and scale) of the Wishart prior for \code{S0}
 (default 4 and identity matrix);  See details.}

\item{output}{list of posterior summaries:

\itemize{
\item \code{grid_y}, a vector of points where to evaluate the estimated posterior mean density of
\code{y}, conditionally on each value of \code{x} in \code{grid_x};

\item \code{grid_x}, a vector of points where to evaluate the realization of the posterior conditional densities of
\code{y} given \code{x};
\item \code{out_type}, if \code{out_type = "FULL"}, the function returns the estimated partitions and the realizations of the posterior density for each iteration;
If \code{out_type = "MEAN"}, return the estimated partitions and the mean of the densities sampled at each iteration;
If \code{out_type = "CLUST"}, return the estimated partitions. Default \code{out_type = "FULL"};
\item \code{out_param}, if equal to \code{TRUE}, the function returns the draws of the kernel's
  parameters for each MCMC iteration, default is \code{FALSE}. See \code{value} for details.

}}
}
\value{
A \code{BNPdens} class object containing the estimated density and
the cluster allocations for each iterations. The output contains also the data and
the grids. If \code{out_param = TRUE} the output
contains also the kernel specific parameters for each iteration. If \code{mcmc_dens = TRUE}, the
function returns also a realization from the posterior density for each iteration.
If \code{mean_dens = TRUE}, the output contains just the mean of the densities sampled at each iteration.
The output retuns also the number of iterations,
the number of burn-in iterations, the computational time and the type of model.
}
\description{
The \code{PYregression} function generates a posterior sample
for mixtures of linear regression models inspired by the ANOVA-DDP model
introduced in De Iorio et al. (2004). See details below for model specification.
}
\details{
This function fits a Pitman-Yor process mixture of Gaussian linear regression models, i.e
\deqn{\tilde f(y) = \int \phi(y; x^T \beta, \sigma^2) \tilde p (d \beta, d \sigma^2)}{%
      \tilde f(y) = \int \phi(y; x^T \beta, \sigma^2) \tilde p (d \beta, d \sigma^2),}
      where \eqn{x} is a bivariate vector containing the dependent variable in \code{x} and a value of 1
       for the intercept term.
The mixing measure \eqn{\tilde p} has a Pitman-Yor process prior with strength \eqn{\vartheta},
discount parameter \eqn{\alpha} and base measures \eqn{P_0} specified as
\deqn{P_0(d \beta, d \sigma^2) = N(d \beta; m_0, S_0) \times IGa(d \sigma^2; a_0, b_0).}{%
      P0(d \beta, d \sigma^2) = N(d \beta; m0, S0)  IG(d \sigma^2; a0, b0).}
 Optional hyperpriors complete the model specification:
\deqn{m_0 \sim N(m_1, S_0 / k_1 ),\quad S_0 \sim IW(\nu_1, S_1),\quad b_0 \sim G(\tau_1, \zeta_1).}{%
m_0 ~ N(m1, S0/k1),  S0 ~ IW(\nu1, S1),  b0 ~ G(\tau1, \zeta1).}

\strong{Posterior simulation methods}

This generic function implements three types of MCMC algorithms for posterior simulation.
The default method is the importance conditional sampler \code{'ICS'} (Canale et al. 2019). Other options are
the marginal sampler \code{'MAR'} (algorithm 8 of Neal, 2000) and the slice sampler \code{'SLI'} (Kalli et al. 2011).
The importance conditional sampler performs an importance sampling step when updating the values of
individual parameters \eqn{\theta}, which requires to sample \code{m_imp} values from a suitable
proposal. Large values of \code{m_imp} are known to improve the mixing of the posterior distribution
at the cost of increased running time (Canale et al. 2019). When updateing the individual parameter
\eqn{\theta}, Algorithm 8 of Neal, 2000, requires to sample \code{m_marginal} values from the base
measure. \code{m_marginal} can be chosen arbitrarily. Two options are available for the slice sampler,
namely the dependent slice-efficient sampler (\code{slice_type = 'DEP'}), which is set as default, and the
independent slice-efficient sampler (\code{slice_type = 'INDEP'}) (Kalli et al. 2011).
}
\examples{
x_toy <- c(rnorm(100, 3, 1), rnorm(100, 3, 1))
y_toy <- c(x_toy[1:100] * 2 + 1, x_toy[101:200] * 6 + 1) + rnorm(200, 0, 1)
grid_x <- c(0, 1, 2, 3, 4, 5)
grid_y <- seq(0, 35, length.out = 50)
est_model <- PYregression(y = y_toy, x = x_toy,
mcmc = list(niter = 200, nburn = 100),
output = list(grid_x = grid_x, grid_y = grid_y))
summary(est_model)
plot(est_model)

}
\references{
Canale, A., Corradin, R., Nipoti, B. (2019), Importance conditional sampling for Bayesian nonparametric mixtures,
arXiv preprint, 	arXiv:1906.08147

De Iorio, M., Mueller, P., Rosner, G.L., and MacEachern, S. (2004), An ANOVA Model for Dependent Random Measures,
Journal of the American Statistical Association 99, 205-215

Kalli, M., Griffin,  J. E., and Walker,  S. G. (2011), Slice sampling mixture models.
Statistics and Computing 21, 93-105.

Neal, R. M. (2000), Markov Chain Sampling Methods for Dirichlet Process Mixture Models,
Journal of Computational and Graphical Statistics 9, 249-265.
}
