% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Dyslexia}
\alias{Dyslexia}
\title{Data on a group of college students diagnosed with dyslexia}
\format{A data frame/tibble with eight observations on seven variables
\describe{ 
\item{words}{number of words read per minute} 
\item{age}{age of participant} 
\item{gender}{a factor with levels \code{female} and 
\code{male}} 
\item{handed}{a factor with levels \code{left} and \code{right}}
\item{weight}{weight of participant (in pounds)} 
\item{height}{height of participant (in inches)} 
\item{children}{number of children in family} 
}}
\usage{
Dyslexia
}
\description{
Data for Exercise 2.90
}
\examples{

plot(height ~ weight, data = Dyslexia)
plot(words ~ factor(handed), data = Dyslexia,
     xlab = "hand", col = "lightblue")

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
