% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Scales}
\alias{Scales}
\title{Readings obtained from a 100 pound weight placed on four brands of bathroom
scales}
\format{A data frame/tibble with 20 observations on two variables
\describe{ 
\item{brand}{variable indicating brand of bathroom scale (\code{A}, \code{B}, \code{C}, or \code{D})} 
\item{reading}{recorded value (in pounds) of a 100 pound weight} 
}}
\usage{
Scales
}
\description{
Data for Exercise 1.89
}
\examples{

boxplot(reading ~ brand, data = Scales, col = rainbow(4), 
ylab = "Weight (lbs)")
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Scales, aes(x = brand, y = reading, fill = brand)) + 
           geom_boxplot() + 
           labs(y = "weight (lbs)") +
           theme_bw() + 
           theme(legend.position = "none") 
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
