% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateLoglike.R
\name{estimateLoglike}
\alias{estimateLoglike}
\title{Estimate the synthetic likelihood}
\usage{
estimateLoglike(
  ssy,
  ssx,
  method = c("BSL", "uBSL", "semiBSL", "BSLmisspec"),
  log = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{ssy}{The observed summary statisic.}

\item{ssx}{A matrix of the simulated summary statistics. The number
of rows is the same as the number of simulations per iteration.}

\item{method}{A string argument indicating the method to be used. The
default, ``BSL'', runs standard BSL. ``uBSL'' uses the unbiased estimator
of a normal density of \insertCite{Ghurye1969;textual}{BSL}. ``semiBSL''
runs the semi-parametric BSL algorithm and is more robust to non-normal
summary statistics. ``BSLmisspec'' estimates the Gaussian synthetic
likelihood whilst acknowledging that there may be incompatibility between
the model and the observed summary statistic \insertCite{Frazier2019}{BSL}.}

\item{log}{A logical argument indicating if the log of likelihood is
given as the result. The default is \code{TRUE}.}

\item{verbose}{A logical argument indicating whether an error message
should be printed if the function fails to compute a likelihood. The
default is \code{FALSE}.}

\item{...}{Arguments to be passed to methods.

  \itemize{

  \item \code{shrinkage} Available for methods ``BSL'' and ``semiBSL''. A
  string argument indicating which shrinkage method to be used. The default
  is \code{NULL}, which means no shrinkage is used. Shrinkage estimation is
  only available for methods ``BSL'' and ``semiBSL''. Current options are
  ``glasso'' for the graphical lasso method of
  \insertCite{Friedman2008;textual}{BSL} and ``Warton'' for the ridge
  regularisation method of \insertCite{Warton2008;textual}{BSL}.

  \item \code{penalty} Available for methods ``BSL'' and ``semiBSL''. The
  penalty value to be used for the specified shrinkage method. Must be
  between zero and one if the shrinkage method is ``Warton''.

  \item \code{standardise} Available for method ``BSL''. A logical argument
  that determines whether to standardise the summary statistics before
  applying the graphical lasso. This is only valid if method is ``BSL'',
  shrinkage is ``glasso'' and penalty is not \code{NULL}. The diagonal
  elements will not be penalised if the shrinkage method is ``glasso''. The
  default is \code{FALSE}.

  \item \code{GRC} Available for method ``BSL''. A logical argument
  indicating whether the Gaussian rank correlation matrix
  \insertCite{Boudt2012}{BSL} should be used to estimate the covariance
  matrix in ``BSL'' method. The default is \code{FALSE}, which uses the
  sample covariance by default.

  \item \code{whitening} Available for method ``BSL''. This argument determines
  whether Whitening transformation should be used in ``BSL'' method with
  Warton's shrinkage. Whitening transformation helps decorrelate the summary
  statistics, thus encourages sparsity of the synthetic likelihood covariance
  matrix. This might allow heavier shrinkage to be applied without losing
  much accuracy, hence allowing the number of simulations to be reduced. By
  default, \code{NULL} represents no Whitening transformation. Otherwise this
  is enabled if a Whitening matrix is provided. See
  \code{\link{estimateWhiteningMatrix}} for the function to estimate the
  Whitening matrix.

  \item \code{ssyTilde} Available for method ``BSL''. The whitened observed
  summary statisic. If this is not \code{NULL}, it will be used to save
  computation effort. Only used if Whitening is enabled.

  \item \code{kernel} Available for method ``semiBSL''.  A string argument
  indicating the smoothing kernel to pass into \code{density} for estimating
  the marginal distribution of each summary statistic. Only ``gaussian" and
  ``epanechnikov" are available. The default is ``gaussian".

  \item \code{type} Available for method ``BSLmisspec''.  A string argument
  indicating which method is used to account for and detect potential
  incompatibility. The two options are "mean" and "variance".

  \item \code{gamma} Available for method ``BSLmisspec''. The additional
  latent parameter to account for possible incompatability between the model
  and observed summary statistic. In ``BSLmisspec'' method, this is updated
  with a slice sampler \insertCite{Neal2003}{BSL}.

  }}
}
\value{
The estimated synthetic (log) likelihood value.
}
\description{
This function computes the estimated synthetic (log) likelihood
  using one of the four methods (``BSL'', ``uBSL'', ``semiBSL'' and
  ``BSLmisspec''). Please find the links below in the see also section for
  more details.
}
\examples{
data(ma2)
ssy <- ma2_sum(ma2$data)
m <- newModel(fnSim = ma2_sim, fnSum = ma2_sum, simArgs = ma2$sim_args,
                  theta0 = ma2$start)
ssx <- simulation(m, n = 300, theta = c(0.6, 0.2), seed = 10)$ssx
estimateLoglike(ssy, ssx, method = "BSL")
estimateLoglike(ssy, ssx, method = "uBSL")
estimateLoglike(ssy, ssx, method = "semiBSL")
estimateLoglike(ssy, ssx, method = "BSLmisspec", type = "mean", gamma = rep(0.1, 50))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{gaussianSynLike}},
  \code{\link{gaussianSynLikeGhuryeOlkin}},
  \code{\link{semiparaKernelEstimate}} and \code{\link{synLikeMisspec}}.
}
