% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTLLasso-package.R
\docType{data}
\name{GLES}
\alias{GLES}
\title{German Longitudinal Election Study (GLES)}
\format{A list containing data from the German Longitudinal Election Study with 2003 
(partly incomplete) observations. 
The list contains both information on the response (paired comparisons) and different covariates.
\describe{ 
\item{Y}{A response.BTLLasso object for the GLES data including
\itemize{
\item{response: Ordinal paired comparison response vector} 
\item{first.object: Vector containing the first-named party per paired comparison}
\item{second.object: Vector containing the second-named party per paired comparison}
\item{subject: Vector containing a person identifier per paired comparison}
}}
\item{X}{Matrix containing all eight person-specific covariates
\itemize{
\item{Age: Age in years} 
\item{Gender (0: male, 1: female)}
\item{EastWest (0: West Germany, 1: East Germany)}
\item{PersEcon: Personal economic situation, 1: good or very good,
0: else} 
\item{Abitur: School leaving certificate, 1: Abitur/A
levels, 0: else} 
\item{Unemployment: 1: currently unemployed, 0:
else} 
\item{Church: Frequency of attendence in a
church/synagogue/mosque/..., 1: at least once a month, 0: else}
\item{Migration: Are you a migrant / not German since birth? 1: yes,
0: no} 
}
}
\item{Z1}{Matrix containing all four person-party-specific covariates
\itemize{
\item{Climate: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards climate change.}
\item{SocioEcon: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards socio-economic issues.}
\item{Immigration: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards immigration.}
}
}
}}
\source{
\url{http://gles.eu/wordpress/english/}
}
\description{
Data from the German Longitudinal Election Study (GLES), see Rattinger et
al. (2014). The GLES is a long-term study of the German electoral process.
It collects pre- and post-election data for several federal elections, the
data used here originate from the pre-election study for 2013.
}
\examples{

data(GLES)

}
\references{
Rattinger, H., S. Rossteutscher, R. Schmitt-Beck, B. Wessels,
and C. Wolf (2014): Pre-election cross section (GLES 2013). \emph{GESIS Data
Archive, Cologne ZA5700 Data file Version 2.0.0.}

Schauberger, Gunther and Tutz, Gerhard (2015): Modelling Heterogeneity in
Paired Comparison Data - an L1 Penalty Approach with an Application to Party
Preference Data, \emph{Department of Statistics, LMU Munich}, Technical
Report 183
}
\keyword{datasets}

