% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeStratPetersenDiagErrorWHChinook2_fit.R,
%   R/TimeStratPetersenDiagErrorWHChinook_fit.R
\name{TimeStratPetersenDiagErrorWHChinook2_fit}
\alias{TimeStratPetersenDiagErrorWHChinook2_fit}
\alias{TimeStratPetersenDiagErrorWHChinook_fit}
\title{Wrapper (*_fit) to fit the Time Stratified Petersen Estimator
with Diagonal Entries and separating Wild from Hatchery Chinook function.}
\usage{
TimeStratPetersenDiagErrorWHChinook2_fit(
  title = "TSPDE-WHChinook2",
  prefix = "TSPDE-WHChinook2-",
  time,
  n1,
  m2,
  u2.A.YoY,
  u2.N.YoY,
  u2.A.1,
  u2.N.1,
  clip.frac.H.YoY,
  clip.frac.H.1,
  sampfrac = rep(1, length(u2.A.YoY)),
  hatch.after.YoY = NULL,
  bad.m2 = c(),
  bad.u2.A.YoY = c(),
  bad.u2.N.YoY = c(),
  bad.u2.A.1 = c(),
  bad.u2.N.1 = c(),
  logitP.cov = as.matrix(rep(1, length(n1))),
  n.chains = 3,
  n.iter = 2e+05,
  n.burnin = 1e+05,
  n.sims = 2000,
  tauU.alpha = 1,
  tauU.beta = 0.05,
  taueU.alpha = 1,
  taueU.beta = 0.05,
  prior.beta.logitP.mean = c(logit(sum(m2, na.rm = TRUE)/sum(n1, na.rm = TRUE)), rep(0,
    ncol(as.matrix(logitP.cov)) - 1)),
  prior.beta.logitP.sd = c(stats::sd(logit((m2 + 0.5)/(n1 + 1)), na.rm = TRUE), rep(10,
    ncol(as.matrix(logitP.cov)) - 1)),
  tauP.alpha = 0.001,
  tauP.beta = 0.001,
  run.prob = seq(0, 1, 0.1),
  debug = FALSE,
  debug2 = FALSE,
  InitialSeed = ceiling(stats::runif(1, min = 0, 1e+06)),
  save.output.to.files = TRUE,
  trunc.logitP = 15
)

TimeStratPetersenDiagErrorWHChinook_fit(
  title = "TSPDE-WHChinook",
  prefix = "TSPDE-WHChinook-",
  time,
  n1,
  m2,
  u2.A,
  u2.N,
  clip.frac.H,
  sampfrac = rep(1, length(u2.A)),
  hatch.after = NULL,
  bad.n1 = c(),
  bad.m2 = c(),
  bad.u2.A = c(),
  bad.u2.N = c(),
  logitP.cov = as.matrix(rep(1, length(n1))),
  n.chains = 3,
  n.iter = 2e+05,
  n.burnin = 1e+05,
  n.sims = 2000,
  tauU.alpha = 1,
  tauU.beta = 0.05,
  taueU.alpha = 1,
  taueU.beta = 0.05,
  prior.beta.logitP.mean = c(logit(sum(m2, na.rm = TRUE)/sum(n1, na.rm = TRUE)), rep(0,
    ncol(as.matrix(logitP.cov)) - 1)),
  prior.beta.logitP.sd = c(stats::sd(logit((m2 + 0.5)/(n1 + 1)), na.rm = TRUE), rep(10,
    ncol(as.matrix(logitP.cov)) - 1)),
  tauP.alpha = 0.001,
  tauP.beta = 0.001,
  run.prob = seq(0, 1, 0.1),
  debug = FALSE,
  debug2 = FALSE,
  InitialSeed = ceiling(stats::runif(1, min = 0, max = 1e+06)),
  save.output.to.files = TRUE,
  trunc.logitP = 15
)
}
\arguments{
\item{title}{A character string used for a title on reports and graphs}

\item{prefix}{A character string used as the prefix for created files. All
created graph files are of the form prefix-xxxxx.pdf.}

\item{time}{A numeric vector of time used to label the strata. For example,
this could be julian week for data stratified at a weekly level.}

\item{n1}{A numeric vector of the number of marked fish released in each
time stratum.}

\item{m2}{A numeric vector of the number of marked fish from n1 that are
recaptured in each time stratum. All recaptures take place within the
stratum of release. Use the \code{\link{TimeStratPetersenNonDiagError_fit}}
function for cases where recaptures take place outside the stratum of
release.}

\item{u2.A.YoY, u2.N.YoY}{Number of YoY unmarked fish with/without adipose fin clips
All YoY wild fish have NO adipose fin clips; however, hatchery fish are a mixture
of fish with adipose fin clips (a known percentage are marked) and unmarked fish.
So u2.A.YoY MUST be hatchery fish.
   u2.N.YoY is a mixture of wild and hatchery fish.}

\item{u2.A.1, u2.N.1}{Number of Age1 unmarked fish with/with out adipose fin clips
All Age1 wild fish have NO adipose fin clips; however, hatchery fish are a mixture
of fish with adipose fin clips (a known percentage are marked) and unmarked fish.
So u2.A.1 MUST be hatchery fish.
   u2.N.1 is a mixture of wild and hatchery fish.}

\item{clip.frac.H.YoY, clip.frac.H.1}{Fraction of the YoY hatchery/Age1 (from last year's releases) hatchery fish are clipped?\ (between 0 and 1)}

\item{sampfrac}{\strong{Deprecated} because it really doesn't work as intended.
You must remove all references to sampfrac from your code. Contact \email{cschwarz.stat.sfu.ca@gmail.com}
for more information.}

\item{hatch.after.YoY}{A numeric vector with elements belonging to
\code{time}.  At which point do YoY hatchery fish arrive? They arrive in the
immediate stratum AFTER these entries.}

\item{bad.m2}{A numeric vector with elements belonging to \code{time}.  In
some cases, something goes wrong in the stratum, and the number of recovered
marked fish should be ignored. For example, poor handling is suspected to
induce handling induced mortality in the marked fish and so only very few
are recovered.  The values of \code{n1} and \code{m2} will be set to 0
for these strata.}

\item{bad.u2.A.YoY, bad.u2.N.YoY}{List of julian weeks where the value of u2.A.YoY/u2.N.YoY is suspect. 
These are set to NA prior to the fit.}

\item{bad.u2.A.1, bad.u2.N.1}{List of julian weeks where the value of u2.A.1/u2.N.1 is suspect. 
These are set to NA prior to the fit.}

\item{logitP.cov}{A numeric matrix for covariates to fit the
logit(catchability). Default is a single intercept, i.e. all strata have the
same mean logit(catchability).}

\item{n.chains}{Number of parallel MCMC chains to fit.}

\item{n.iter}{Total number of MCMC iterations in each chain.}

\item{n.burnin}{Number of burn-in iterations.}

\item{n.sims}{Number of simulated values to keeps for posterior
distribution.}

\item{tauU.alpha}{One of the parameters along with \code{tauU.beta} for the
prior for the variance of the random noise for the smoothing spline.}

\item{tauU.beta}{One of the parameters along with \code{tauU.alpha} for the
prior for the variance of the random noise for the smoothing spline.}

\item{taueU.alpha}{One of the parameters along with \code{taueU.beta} for
the prior for the variance of noise around the spline.}

\item{taueU.beta}{One of the parameters along with \code{taueU.alpha} for
the prior for the variance of noise around the spline.}

\item{prior.beta.logitP.mean}{Mean of the prior normal distribution for
logit(catchability) across strata}

\item{prior.beta.logitP.sd}{SD of the prior normal distribution for
logit(catchability) across strata}

\item{tauP.alpha}{One of the parameters for the prior for the variance in
logit(catchability) among strata}

\item{tauP.beta}{One of the parameters for the prior for the variance in
logit(catchability) among strata}

\item{run.prob}{Numeric vector indicating percentiles of run timing should
be computed.}

\item{debug}{Logical flag indicating if a debugging run should be made. In
the debugging run, the number of samples in the posterior is reduced
considerably for a quick turn around.}

\item{debug2}{Logical flag indicated if additional debugging information is
produced. Normally the functions will halt at \code{browser()} calls to
allow the user to peek into the internal variables. Not useful except to
package developers.}

\item{InitialSeed}{Numeric value used to initialize the random numbers used
in the MCMC iterations.}

\item{save.output.to.files}{Should the plots and text output be save to the files
in addition to being stored in the MCMC object?}

\item{trunc.logitP}{Truncate logit(P) between c(=trunc.logitP, trunc.logitP) when plotting the
logitP over time. Actual values of logit(P) are not affected.}

\item{u2.A}{A numeric vector of the number of unmarked fish with adipose
clips captured in each stratum.}

\item{u2.N}{A numeric vector of the number of unmarked fish with NO-adipose
clips captured in each stratum.}

\item{clip.frac.H}{A numeric value for the fraction of the hatchery fish
that have the adipose fin clipped (between 0 and 1).}

\item{hatch.after}{A numeric vector with elements belonging to \code{time}.
At which point do hatchery fish arrive? They arrive in the immediate stratum
AFTER these entries.}

\item{bad.n1}{A numeric vector with elements belonging to \code{time}.  In
some cases, something goes wrong in the stratum, and the number of marked
fish releases should be discarded.  The values of \code{n1} and \code{m2} will be set to
0 for these strata.}

\item{bad.u2.A}{A numeric vector with elements belonging to \code{time}.  In
some cases, something goes wrong in the stratum, and the number of unmarked
fish with an adipose fin clip should be ignored.}

\item{bad.u2.N}{A numeric vector with elements belonging to \code{time}.  In
some cases, something goes wrong in the stratum, and the number of unmarked
fish with NO adipose fin clip should be ignored.}
}
\value{
An MCMC object with samples from the posterior distribution. A
series of graphs and text file are also created in the working directory.
}
\description{
Takes the number of marked fish released, the number of recaptures, and the
number of unmarked fish and uses Bayesian methods to fit a fit a spline
through the population numbers and a hierarchical model for the trap
efficiencies over time.  The output is written to files and an MCMC object
is also created with samples from the posterior.
}
\details{
Normally use the *_fit to pass the data to the fitting function.
}
\examples{
 
##---- See the vignettes for examples on how to run this analysis.

}
\references{
Bonner, S. J., & Schwarz, C. J. (2011). 
Smoothing population size estimates for Time-Stratified Mark-Recapture experiments Using Bayesian P-Splines. 
Biometrics, 67, 1498-1507. 
\doi{10.1111/j.1541-0420.2011.01599.x}

Schwarz, C. J., & Dempson, J. B. (1994).
Mark-recapture estimation of a salmon smolt population. 
Biometrics, 50, 98-108.

Schwarz, C.J., D. Pickard, K. Marine and S.J. Bonner. 2009. Juvenile Salmonid Outmigrant
Monitoring Evaluation, Phase II - December 2009. Final Technical Memorandum for the Trinity River
Restoration Program, Weaverville, CA. 155 pp. + appendices available at
\url{https://www.trrp.net/library/document/?id=369}
}
\author{
Bonner, S.J. \email{sbonner6@uwo.ca} and 
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{~models}
\keyword{~smooth}
