% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgnbd.R
\name{bgnbd.cbs.LL}
\alias{bgnbd.cbs.LL}
\title{BG/NBD Log-Likelihood Wrapper}
\usage{
bgnbd.cbs.LL(params, cal.cbs)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that
order. r and alpha are unobserved parameters for the NBD transaction
process. a and b are unobserved parameters for the Beta geometric dropout
process.}

\item{cal.cbs}{calibration period CBS (customer by sufficient statistic). It
must contain columns for frequency ("x"), recency ("t.x"), and total time
observed ("T.cal"). Note that recency must be the time between the start of
the calibration period and the customer's last transaction, not the time
between the customer's last transaction and the end of the calibration
period. If your data is compressed (see \code{\link{dc.compress.cbs}}),
a fourth column labeled "custs" (number of customers with a specific
combination of recency, frequency and length of calibration period) is
available.}
}
\value{
The total log-likelihood of the provided data.
}
\description{
Calculates the log-likelihood sum of the BG/NBD model.
}
\details{
Note: do not use a compressed \code{cal.cbs} matrix. It makes quicker work
for Pareto/NBD estimation as implemented in this package, but the opposite is
true for BG/NBD. For proof, compare the definition of the
\code{\link{bgnbd.cbs.LL}} to that of \code{\link{pnbd.cbs.LL}}.
}
\examples{
data(cdnowSummary)

cal.cbs <- cdnowSummary$cbs
# cal.cbs already has column names required by method

# random assignment of parameters
params <- c(0.5, 6, 1.2, 3.3)
# returns the log-likelihood of the given parameters
bgnbd.cbs.LL(params, cal.cbs)

# compare the speed and results to the following:
cal.cbs.compressed <- dc.compress.cbs(cal.cbs)
bgnbd.cbs.LL (params, cal.cbs.compressed)

# Returns the log likelihood of the parameters for a customer who
# made 3 transactions in a calibration period that ended at t=6,
# with the last transaction occurring at t=4.
bgnbd.LL(params, x=3, t.x=4, T.cal=6)

# We can also give vectors as function parameters:
set.seed(7)
x <- sample(1:4, 10, replace = TRUE)
t.x <- sample(1:4, 10, replace = TRUE)
T.cal <- rep(4, 10)
bgnbd.LL(params, x, t.x, T.cal)
}
\seealso{
\code{\link{bgnbd.EstimateParameters}}

\code{\link{bgnbd.LL}}
}
