% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spend.R
\name{spend.expected.value}
\alias{spend.expected.value}
\title{Conditional expected transaction value}
\usage{
spend.expected.value(params, m.x, x)
}
\arguments{
\item{params}{a vector of gamma-gamma parameters: p, q, and gamma, in that
order. p is the shape parameter for each transaction. The scale parameter
for each transaction is distributed across customers according to a gamma
distribution with parameters q (shape) and gamma (scale).}

\item{m.x}{the customer's average observed transaction value in the
calibration period. May also be a vector of average observed transaction
values - see details.}

\item{x}{the number of transactions the customer made in the calibration
period. May also be a vector of frequencies - see details.}
}
\value{
The expected transaction value for a customer conditional on their
transaction behavior during the calibration period. If m.x or x has a
length greater than one, then a vector of expected transaction values will
be returned.
}
\description{
Calculates the expected transaction value for a customer, conditional on the
number of transaction and average transaction value during the calibration
period.
}
\details{
E(M | p, q, gamma, m.x, x).

m.x and x may be vectors. The standard rules for vector operations apply - if
they are not of the same length, the shorter vector will be recycled (start
over at the first element) until it is as long as the longest vector. It is
advisable to keep vectors to the same length and to use single values for
parameters that are to be the same for all calculations. If one of these
parameters has a length greater than one, the output will be a vector of
probabilities.
}
\examples{
\dontrun{
data(cdnowSummary)
ave.spend <- cdnowSummary$m.x
tot.trans <- cdnowSummary$cbs[,"x"]
# params <- c(6, 4, 16); # in original documentation. rounded values of:
params <- spend.EstimateParameters(m.x.vector = ave.spend, x.vector = tot.trans);
# calculate the expected transaction value of a customer
# who spent an average of $35 over 3 transactions.
spend.expected.value(params, m.x=35, x=3)

# m.x and x may be vectors:
spend.expected.value(params, m.x=30:40, x=3)
spend.expected.value(params, m.x=35, x=1:10)
spend.expected.value(params, m.x=30:40, x=1:11)
}
}
\references{
Fader, Peter S., Bruce G.S. Hardie, and Ka L. Lee. “RFM and CLV:
Using Iso-Value Curves for Customer Base Analysis.” Journal of Marketing
Research Vol.42, pp.415-430. November. 2005.
\href{http://www.brucehardie.com/papers/rfm_clv_2005-02-16.pdf}{Web.}
}
