% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto-nbd-mcmc.R
\name{pnbd.GenerateData}
\alias{pnbd.GenerateData}
\title{Simulate data according to Pareto/NBD model assumptions}
\usage{
pnbd.GenerateData(n, T.cal, T.star, params, date.zero = "2000-01-01")
}
\arguments{
\item{n}{Number of customers.}

\item{T.cal}{Length of calibration period. If a vector is provided, then it
is assumed that customers have different 'birth' dates, i.e.
\eqn{max(T.cal)-T.cal}.}

\item{T.star}{Length of holdout period. This may be a vector.}

\item{params}{A list of model parameters \code{r},
\code{alpha}, \code{s}, \code{beta}.}

\item{date.zero}{Initial date for cohort start. Can be of class character, Date or POSIXt.}
}
\value{
List of length 2:
\item{\code{cbs}}{A data.frame with a row for each customer and the summary statistic as columns.}
\item{\code{elog}}{A data.frame with a row for each transaction, and columns \code{cust}, \code{date} and \code{t}.}
}
\description{
Simulate data according to Pareto/NBD model assumptions
}
\examples{
params <- list(r = 5, alpha = 10, s = 0.8, beta = 12)
data <- pnbd.GenerateData(n = 1000, T.cal = 32, T.star = 32, params)
cbs <- data$cbs  # customer by sufficient summary statistic - one row per customer
elog <- data$elog  # Event log - one row per event/purchase
}

