% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/64_irf_method.R, R/65_irf_print.R
\name{irf.bvar}
\alias{irf.bvar}
\alias{fevd.bvar}
\alias{irf}
\alias{fevd}
\alias{print.bvar_irf}
\alias{print.bvar_fevd}
\alias{summary.bvar_irf}
\title{Impulse response and forecast error methods for Bayesian VARs}
\usage{
\method{irf}{bvar}(x, ..., conf_bands, n_thin = 1L)

\method{fevd}{bvar}(x, ..., conf_bands = 0.5, n_thin = 1L)

irf(x, ...)

fevd(x, ...)

\method{print}{bvar_irf}(x, ...)

\method{print}{bvar_fevd}(x, digits = 4L, complete = FALSE, ...)

\method{summary}{bvar_irf}(object, vars_impulse = NULL,
  vars_response = NULL, ...)
}
\arguments{
\item{x, object}{A \code{bvar} object, obtained from \code{\link{bvar}}.
Summary and print methods take in a \code{bvar_irf} / \code{bvar_fevd}
object.}

\item{...}{A \code{bv_irf} object or arguments to be fed into
\code{\link{bv_irf}}. Contains settings for the IRFs / FEVDs.}

\item{conf_bands}{Numeric vector of desired confidence bands to apply.
E.g. for bands at 5\%, 10\%, 90\% and 95\% set this to \code{c(0.05, 0.1)}.
Note that the median, i.e. \code{0.5} is always included.}

\item{n_thin}{Integer scalar. Every \emph{n_thin}'th draw in \emph{x} is used
for calculations, others are dropped.}

\item{digits}{Integer scalar. Fed to \code{\link[base]{round}} and applied to
numeric outputs (i.e. the quantiles).}

\item{complete}{Logical scalar. Whether to print only medians or all
available confidence bands of a a \code{bvar_fevd} object.}

\item{vars_impulse, vars_response}{Optional numeric or character vector. Used
to subset the summary's impulses / responses to certain variables by position
or name (must be available). Defaults to \code{NULL}, i.e. all variables.}
}
\value{
Returns a list of class \code{bvar_irf} including IRFs and optionally
FEVDs at desired confidence bands. Also see \code{\link{bvar}}.
Note that the \code{fevd} method only returns a numeric array of FEVDs at
desired confidence bands.
The summary method returns a numeric array of impulse responses at the
specified confidence bands.
}
\description{
Retrieves / calculates impulse response functions (IRFs) and/or forecast
error variance decompositions (FEVDs) for Bayesian VARs generated via
\code{\link{bvar}}. If the object is already present and no settings are
supplied it is simply retrieved, otherwise it will be calculated ex-post.
Note that FEVDs require the presence / calculation of IRFs.
To store IRFs you may want to assign the output of \code{irf.bvar} to
\code{x$irf}. May also be used to update confidence bands, i.e.
credible intervals.
}
\examples{
\donttest{
data <- matrix(rnorm(400), ncol = 4)
x <- bvar(data, lags = 2)

# Add IRFs
x$irf <- irf(x)

# Access IRFs and update confidence bands
irf(x, conf_bands = 0.01)

# Compute and store IRFs with a longer horizon
x$irf <- irf(x, horizon = 24L)

# Lower draws, use `bv_irf()` to set options and add confidence bands
irf(x, bv_irf(24L), n_thin = 10L, conf_bands = c(0.05, 0.16))

# Get a summary of the last saved IRFs
summary(x)

# Limit the summary to responses of variable #2
summary(x, vars_response = 2L)
}
}
\seealso{
\code{\link{bvar}}; \code{\link{plot.bvar_irf}};
\code{\link{bv_irf}}
}
\keyword{BVAR}
\keyword{VAR}
\keyword{fevd}
\keyword{forecast-error-variance-decomposition}
\keyword{impulse-responses}
\keyword{irf}
