% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unassigned_bamorc.R
\name{unassigned_bamorc}
\alias{unassigned_bamorc}
\title{Calculates the referencing correction value for unassigned protein NMR peaklists.
\code{unassigned_bamorc()} will analyze unassigned protein NMR spectra, first groups the peaklist via SSC, then estimates the secondary structure via JPred, finally using BaMORC core function to calculate the reference correction value.}
\usage{
unassigned_bamorc(peakList_file_loc, sequence,
  secondary_structure = NULL, from = -5, to = 5,
  ssc = "moseleybioinformaticslab/ssc",
  para = "--plformat=sparky --stype=HNcoCACB --dims=H,N,CA/CB --rdims=H,N")
}
\arguments{
\item{peakList_file_loc}{NMR HNCACB file location}

\item{sequence}{sequence string of protein of interest}

\item{secondary_structure}{string of secondary structure if available}

\item{from}{the lower bound of the optimization}

\item{to}{the upper bound of the optimization}

\item{ssc}{location of ssc docker image}

\item{para}{parameter input for ssc function (no need to change)}
}
\value{
Reference correction value.
}
\description{
Calculates the referencing correction value for unassigned protein NMR peaklists.
\code{unassigned_bamorc()} will analyze unassigned protein NMR spectra, first groups the peaklist via SSC, then estimates the secondary structure via JPred, finally using BaMORC core function to calculate the reference correction value.
}
\examples{
sequence = "RPAFCLEPPYAGPGKARIIRYFYNAAAGAAQAFVYGGVRAKRNNFASAADALAACAAA"
peakList_file_loc = system.file("extdata", "bpti_HNcoCACB.txt", package = "BaMORC")
\dontrun{unassigned_bamorc(peakList_file_loc, sequence, secondary_structure=NULL,
from=-5, to=5, ssc="moseleybioinformaticslab/ssc",
para="--plformat=sparky --stype=HNcoCACB --dims=H,N,CA/CB --rdims=H,N")}
# Expected result should be around (due to randomness): 0.0007890328
}
