% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimate.R
\docType{methods}
\name{estimate,NHPP-method}
\alias{estimate,NHPP-method}
\title{Estimation for a non-homogeneous Poisson process}
\usage{
\S4method{estimate}{NHPP}(model.class, t, data, nMCMC, propSd, adapt = TRUE,
  proposal = c("normal", "lognormal"))
}
\arguments{
\item{model.class}{class of the NHPP model including all required information, see \code{\link{NHPP-class}}}

\item{t}{vector of time points}

\item{data}{vector of observation variables}

\item{nMCMC}{length of Markov chain}

\item{propSd}{vector of proposal variances for \eqn{\xi}}

\item{adapt}{if TRUE (default), proposal variance is adapted}

\item{proposal}{proposal density: "normal" (default) or "lognormal" (for positive parameters)}
}
\description{
Bayesian estimation of a non-homogeneous Poisson process (NHPP) with cumulative intensity function \eqn{\Lambda(t, \xi)}.
}
\examples{
model <- set.to.class("NHPP", parameter = list(xi = c(5, 1/2)),
                   Lambda = function(t, xi) (t/xi[2])^xi[1])
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
est <- estimate(model, t, data$Times, 10000, proposal = "lognormal")
plot(est)

##
model <- set.to.class("NHPP", parameter = list(xi = 5),
                   Lambda = function(t, xi) t*xi)
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
est <- estimate(model, t, data$N, 10000)
plot(est, par.options = list(mfrow = c(1,1)))
}
\references{
Hermann, S., K. Ickstadt and C. H. Mueller (2015).
Bayesian Prediction for a Jump Diffusion Process with Application to Crack Growth in Fatigue Experiments.
SFB 823 discussion paper 30/15.
}

