% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,jumpRegression-method}
\alias{simulate,jumpRegression-method}
\title{Simulation of regression model dependent on Poisson process}
\usage{
\S4method{simulate}{jumpRegression}(object, nsim = 1, seed = NULL, t,
  plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "jumpRegression"}

\item{nsim}{number of trajectories to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of of the regression model
  \eqn{y_i = f(t_i, N_{t_i}, \theta) + \epsilon_i} with
  \eqn{N_t\sim Pois(\Lambda(t, \xi)), \epsilon_i\sim N(0,\gamma^2\widetilde{s}(t))}.
}
\examples{
model <- set.to.class("jumpRegression", fun = function(t, N, theta) theta[1]*t + theta[2]*N,
   parameter = list(theta = c(1,2), gamma2 = 0.1, xi = 10))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t)
}

