% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{checkCorr}
\alias{checkCorr}
\alias{checkCorr,Eval-method}
\title{Function to show correlations of a simulated organism or substrate}
\usage{
checkCorr(object, corr = NULL, tocheck = list())

\S4method{checkCorr}{Eval}(object, corr = NULL, tocheck = list())
}
\arguments{
\item{object}{An object of class Eval.}

\item{corr}{A correlation matrix (\code{\link{getCorrM}})}

\item{tocheck}{A list with substrate, reactions or organism names whose correlations should be shown}
}
\description{
The generic function \code{checkCorr} returns the correlation matrix of several objects.
}
\details{
Returns correlation matrix which can be used for statistical analysis
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
checkCorr(eval, tocheck="o2")
}
\seealso{
\code{\link{Eval-class}} and \code{\link{getCorrM}}
}

