% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\name{growExp}
\alias{growExp}
\alias{growExp,Organism-method}
\title{Function for letting organisms grow exponentially}
\usage{
growExp(object, biomass, fbasol, tstep)

\S4method{growExp}{Organism}(object, biomass, fbasol, tstep)
}
\arguments{
\item{object}{An object of class Organisms.}

\item{biomass}{A number indicating the current biomass, which has to be updated.}

\item{fbasol}{Problem object according to the constraints and then solved with \code{optimizeProb}.}

\item{tstep}{A number giving the time intervals for each simulation step.}
}
\value{
Returns the updated biomass of the organisms of interest.
}
\description{
The generic function \code{growExp} implements a growth model of organisms in their environment.
}
\details{
Exponential growth of organisms is implemented by adding the calculated growthrate multiplied with the current growth calculated by \code{optimizeLP} plus to the already present growth value
}
\seealso{
\code{\link{Organism-class}} and \code{\link{optimizeLP}}
}
