% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcorsis.R, R/bcov.R
\name{bcor}
\alias{bcor}
\alias{bcov}
\title{Ball Covariance and Correlation Statistics}
\usage{
bcor(x, y, distance = FALSE, weight = FALSE)

bcov(x, y, distance = FALSE, weight = FALSE)
}
\arguments{
\item{x}{a numeric vector, matrix, data.frame, or a list containing at least two numeric vectors, matrices, or data.frames.}

\item{y}{a numeric vector, matrix, or data.frame.}

\item{distance}{if \code{distance = TRUE}, the elements of \code{x} and \code{y} are considered as distance matrices.}

\item{weight}{a logical or character string used to choose the weight form of Ball Covariance statistic.. 
If input is a character string, it must be one of \code{"constant"}, \code{"probability"}, or \code{"chisquare"}. 
Any unambiguous substring can be given. 
If input is a logical value, it is equivalent to \code{weight = "probability"} if \code{weight = TRUE} while 
equivalent to \code{weight = "constant"} if \code{weight = FALSE}.
Default: \code{weight = FALSE}.}
}
\value{
\item{\code{bcor }}{ Ball Correlation statistic.}

\item{\code{bcov }}{ Ball Covariance statistic.}
}
\description{
Computes Ball Covariance and Ball Correlation statistics, 
which are generic dependence measures in Banach spaces.
}
\details{
The sample sizes of the two variables must agree,  and samples must not contain missing and infinite values. 
If we set \code{distance = TRUE}, arguments \code{x}, \code{y} can be a \code{dist} object or a
symmetric numeric matrix recording distance between samples; otherwise, these arguments are treated as data.

\code{bcov} and \code{bcor} compute Ball Covariance and Ball Correlation statistics.

Ball Covariance statistics is a generic dependence measure in Banach spaces. It enjoys the following properties: 
\itemize{
\item It is nonnegative and it is equal to zero if and only if variables are unassociated; 
\item It is highly robust;   
\item It is distribution-free and model-free;   
\item it is interesting that the HHG is a special case of Ball Covariance statistics. 
}
Ball correlation statistics, a normalized version of Ball Covariance statistics, generalizes Pearson correlation in two fundamental ways: 
\itemize{
\item It is well-defined for random variables in arbitrary dimension in Banach spaces
\item BCor is equal to zero implies random variables are unassociated.
}

The definitions of the Ball Covariance and Ball Correlation statistics between two random variables are as follows.
Suppose, we are given pairs of independent observations 
\eqn{\{(x_1, y_1),...,(x_n,y_n)\}}, where \eqn{x_i} and \eqn{y_i} can be of any dimension 
and the dimensionality of \eqn{x_i} and \eqn{y_i} need not be the same.
Then, we define sample version Ball Covariance as:
\deqn{\mathbf{BCov}_{\omega, n}^{2}(X, Y)=\frac{1}{n^{2}}\sum_{i,j=1}^{n}{(\Delta_{ij,n}^{X,Y}-\Delta_{ij,n}^{X}\Delta_{ij,n}^{Y})^{2}} }
where:
\deqn{ \Delta_{ij,n}^{X,Y}=\frac{1}{n}\sum_{k=1}^{n}{\delta_{ij,k}^{X} \delta_{ij,k}^{Y}}, 
\Delta_{ij,n}^{X}=\frac{1}{n}\sum_{k=1}^{n}{\delta_{ij,k}^{X}}, 
\Delta_{ij,n}^{Y}=\frac{1}{n}\sum_{k=1}^{n}{\delta_{ij,k}^{Y}} }
\deqn{\delta_{ij,k}^{X} = I(x_{k} \in \bar{B}(x_{i}, \rho(x_{i}, x_{j}))), 
\delta_{ij,k}^{Y} = I(y_{k} \in \bar{B}(y_{i}, \rho(y_{i}, y_{j})))}
Among them, \eqn{\bar{B}(x_{i}, \rho(x_{i}, x_{j}))} is a closed ball 
with center \eqn{x_{i}} and radius \eqn{\rho(x_{i}, x_{j})}.
Similarly, we can define \eqn{ \mathbf{BCov}_{\omega,n}^2(\mathbf{X},\mathbf{X}) } 
and \eqn{ \mathbf{BCov}_{\omega,n}^2(\mathbf{Y},\mathbf{Y}) }. 
We define Ball Correlation statistic as follows.
\deqn{\mathbf{BCor}_{\omega,n}^2(\mathbf{X},\mathbf{Y})=
\mathbf{BCov}_{\omega,n}^2(\mathbf{X},\mathbf{Y})/\sqrt{\mathbf{BCov}_{\omega,n}^2(\mathbf{X},\mathbf{X})\mathbf{BCov}_{\omega,n}^2(\mathbf{Y},\mathbf{Y})}
}

We can extend \eqn{\mathbf{BCov}_{\omega,n}} to measure the mutual independence between \eqn{K} random variables:
\deqn{\frac{1}{n^{2}}\sum_{i,j=1}^{n}{\left[ (\Delta_{ij,n}^{X_{1}, ..., X_{K}}-\prod_{k=1}^{K}\Delta_{ij,n}^{X_{k}})^{2}\prod_{k=1}^{K}{\hat{\omega}_{k}(X_{ki},X_{kj})} \right]}}
where \eqn{X_{k}(k=1,\ldots,K)} are random variables and \eqn{X_{ki}} is the \eqn{i}-th observations of \eqn{X_{k}}. 

See \code{\link{bcov.test}} for a test of independence based on the Ball Covariance statistic.
}
\examples{
############# Ball Correlation #############
num <- 50
x <- 1:num
y <- 1:num
bcor(x, y)
bcor(x, y, weight = "prob")
bcor(x, y, weight = "chisq")
############# Ball Covariance #############
num <- 50
x <- rnorm(num)
y <- rnorm(num)
bcov(x, y)
bcov(x, y, weight = "prob")
bcov(x, y, weight = "chisq")
}
\references{
Wenliang Pan, Xueqin Wang, Heping Zhang, Hongtu Zhu & Jin Zhu (2019) Ball Covariance: A Generic Measure of Dependence in Banach Space, Journal of the American Statistical Association, DOI: 10.1080/01621459.2018.1543600

Wenliang Pan, Xueqin Wang, Weinan Xiao & Hongtu Zhu (2018) A Generic Sure Independence Screening Procedure, Journal of the American Statistical Association, DOI: 10.1080/01621459.2018.1462709

Jin Zhu, Wenliang Pan, Wei Zheng, and Xueqin Wang (2018). Ball: An R package for detecting distribution difference and association in metric spaces. arXiv preprint arXiv:1811.03750. http://arxiv.org/abs/1811.03750
}
\seealso{
\code{\link{bcov.test}}, \code{\link{bcorsis}}
}
