% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Barycenter.R
\name{Barycenter}
\alias{Barycenter}
\title{Computation of a Wasserstein Barycenter}
\usage{
Barycenter(images, maxIter = 10, lambda = 60/median(costMatrix))
}
\arguments{
\item{images}{A list of matrices satisfying the prerequisites described above.}

\item{maxIter}{Maximum gradient iterations.}

\item{lambda}{Non-negative smoothing parameter (c.f. \link{Subgradient}).}
}
\value{
The Barycenter of the images, represented by a \eqn{n x m} matrix. The function returns the Barycenter represented by a \eqn{n x m} matrix and prints also the corresponding image.

Given the MNIST dataset, a Barycenter of the digit three is shown below. The Barycenter is based on 4351 images each represented by
a 28 x 28 pixel grid, respectively. The values for \code{lambda} and \code{maxIter} were set by default. The dataset is also available in this package (c.f. \link{MNIST_three}).

\figure{threeMNIST.png}{test}
}
\description{
The function \code{Barycenter} takes in a list of matrices and computes the
corresponding Barycenter.
The list has to consist of matrices having all the same dimensions and each matrix represents the weights of the corresponding pixels of an image. The pixels should be scaled s.t. they sum up to one.
}
\examples{
#Computation of a Barycenter based on five images representing the digit eight, respectively.
\dontrun{Barycenter(eight)}
}
\author{
Marcel Klatt
}
\references{
Cuturi, M.: \code{Fast Computation of Wasserstein Barycenters}, Proceedings of the International Conference on Machine Learning, Beijing, China, 2014
}

